/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.enablement;

import java.util.Objects;
import org.jboss.weld.util.Preconditions;

class Item
implements Comparable<Item> {
    private final Class<?> javaClass;
    private final Integer priority;

    public Item(Class<?> javaClass) {
        this(javaClass, null);
    }

    public Item(Class<?> javaClass, Integer priority) {
        Preconditions.checkArgumentNotNull(javaClass, "javaClass");
        this.javaClass = javaClass;
        this.priority = priority;
    }

    @Override
    public int compareTo(Item o) {
        if (this.priority.equals(o.priority)) {
            return this.javaClass.getName().compareTo(o.javaClass.getName());
        }
        return this.priority - o.priority;
    }

    public int hashCode() {
        return this.javaClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Item) {
            Item that = (Item)obj;
            return Objects.equals(this.javaClass, that.javaClass);
        }
        return false;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public String toString() {
        return "[Class=" + this.javaClass + ", priority=" + this.priority + "]";
    }
}

