/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jdeparser.AbstractJClassDef;
import org.jboss.jdeparser.AbstractJMethodDef;
import org.jboss.jdeparser.CommentContent;
import org.jboss.jdeparser.CommentTextContent;
import org.jboss.jdeparser.ConstructorJMethodDef;
import org.jboss.jdeparser.InlineDocTagCommentContent;
import org.jboss.jdeparser.JComment;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JParamDeclaration;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypeCommentContent;
import org.jboss.jdeparser.MethodJMethodDef;
import org.jboss.jdeparser.NestedCommentContent;
import org.jboss.jdeparser.NonTrailingSpaceContent;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Writable;

abstract class AbstractJComment
implements JComment,
Writable {
    static final CommentContent NL_CONTENT = new CommentContent(){

        @Override
        public void write(SourceFileWriter writer) throws IOException {
            writer.nl();
        }
    };
    static final CommentTextContent HASH_CONTENT = new CommentTextContent("#");
    static final CommentTextContent OPEN_PAREN_CONTENT = new CommentTextContent("(");
    static final CommentTextContent COMMA_CONTENT = new CommentTextContent(",");
    static final CommentTextContent CLOSE_PAREN_CONTENT = new CommentTextContent(")");
    static final InlineDocTagCommentContent DOC_ROOT_CONTENT = new InlineDocTagCommentContent("docRoot");
    private List<Writable> content;

    AbstractJComment() {
    }

    void addItemDirectly(Writable item) {
        if (item != null) {
            List<Writable> content = this.content;
            if (content == null) {
                content = this.content = new ArrayList<Writable>();
            }
            content.add(item);
        }
    }

    protected <T extends CommentContent> T add(T item) {
        this.addItemDirectly(item);
        return item;
    }

    @Override
    public JComment text(String text) {
        int s = 0;
        int i = 0;
        while (i < text.length()) {
            int c = text.codePointAt(i);
            if (c == 10) {
                if (i - s > 0) {
                    this.add(new CommentTextContent(text.substring(s, i)));
                }
                this.add(NL_CONTENT);
                s = i + 1;
            } else if (Character.isWhitespace(c)) {
                if (i - s > 0) {
                    this.add(new CommentTextContent(text.substring(s, i)));
                }
                this.add(NonTrailingSpaceContent.getInstance());
                s = i + 1;
            }
            i = text.offsetByCodePoints(i, 1);
        }
        if (i - s > 0) {
            this.add(new CommentTextContent(text.substring(s, i)));
        }
        return this;
    }

    @Override
    public JComment sp() {
        this.add(NonTrailingSpaceContent.getInstance());
        return this;
    }

    @Override
    public JComment typeName(JType type) {
        this.add(new JTypeCommentContent(type));
        return this;
    }

    @Override
    public JComment block() {
        return this.add(new NestedCommentContent());
    }

    @Override
    public JComment inlineDocTag(String tag, String body) {
        InlineDocTagCommentContent content = new InlineDocTagCommentContent(tag);
        this.add(content).text(body);
        return this;
    }

    @Override
    public JComment inlineDocTag(String tag) {
        return this.add(new InlineDocTagCommentContent(tag));
    }

    @Override
    public JComment linkType(boolean plain, JType targetType) {
        InlineDocTagCommentContent link = new InlineDocTagCommentContent(plain ? "linkplain" : "link");
        link.typeName(targetType);
        link.sp();
        return this.add(link);
    }

    @Override
    public JComment linkField(boolean plain, JType targetType, String targetField) {
        InlineDocTagCommentContent item = new InlineDocTagCommentContent(plain ? "linkplain" : "link");
        item.typeName(targetType);
        item.add(HASH_CONTENT);
        item.text(targetField);
        item.sp();
        return this.add(item);
    }

    @Override
    public JComment linkConstructor(boolean plain, JType targetType, JType ... params) {
        InlineDocTagCommentContent item = new InlineDocTagCommentContent(plain ? "linkplain" : "link");
        item.typeName(targetType);
        item.add(HASH_CONTENT);
        item.typeName(targetType);
        item.add(OPEN_PAREN_CONTENT);
        int i = 0;
        while (i < params.length) {
            item.add(new JTypeCommentContent(params[i].erasure()));
            while (i < params.length) {
                item.add(COMMA_CONTENT);
                item.add(new JTypeCommentContent(params[i].erasure()));
                ++i;
            }
        }
        item.add(CLOSE_PAREN_CONTENT);
        item.sp();
        return this.add(item);
    }

    @Override
    public JComment linkMethod(boolean plain, JType targetType, String targetMethod, JType ... params) {
        InlineDocTagCommentContent item = new InlineDocTagCommentContent(plain ? "linkplain" : "link");
        item.typeName(targetType);
        item.add(HASH_CONTENT);
        item.text(targetMethod);
        item.add(OPEN_PAREN_CONTENT);
        int i = 0;
        while (i < params.length) {
            item.add(new JTypeCommentContent(params[i].erasure()));
            while (i < params.length) {
                item.add(COMMA_CONTENT);
                item.add(new JTypeCommentContent(params[i].erasure()));
                ++i;
            }
        }
        item.add(CLOSE_PAREN_CONTENT);
        item.sp();
        return this.add(item);
    }

    @Override
    public JComment linkMethod(boolean plain, JMethodDef methodDef) {
        if (methodDef instanceof AbstractJMethodDef) {
            CommentContent name;
            AbstractJMethodDef abstractJMethodDef = (AbstractJMethodDef)methodDef;
            AbstractJClassDef clazz = abstractJMethodDef.clazz();
            JTypeCommentContent typeContent = new JTypeCommentContent(clazz.erasedType());
            if (methodDef instanceof MethodJMethodDef) {
                name = new CommentTextContent(((MethodJMethodDef)methodDef).getName());
            } else {
                assert (methodDef instanceof ConstructorJMethodDef);
                name = typeContent;
            }
            InlineDocTagCommentContent item = new InlineDocTagCommentContent(plain ? "linkplain" : "link");
            item.add(typeContent);
            item.add(HASH_CONTENT);
            item.add(name);
            item.add(OPEN_PAREN_CONTENT);
            JParamDeclaration[] params = abstractJMethodDef.params();
            if (params.length > 0) {
                item.add(new JTypeCommentContent(params[0].type().erasure()));
                for (int i = 1; i < params.length; ++i) {
                    item.add(COMMA_CONTENT);
                    item.add(new JTypeCommentContent(params[i].type().erasure()));
                }
            }
            item.add(CLOSE_PAREN_CONTENT);
            item.sp();
            return this.add(item);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public JComment code() {
        return this.inlineDocTag("code");
    }

    @Override
    public JComment docRoot() {
        this.add(DOC_ROOT_CONTENT);
        return this;
    }

    @Override
    public JComment nl() {
        this.add(NL_CONTENT);
        return this;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        for (Writable item : this.content) {
            item.write(writer);
        }
    }

    List<Writable> getContent() {
        return this.content;
    }
}

