/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.taskdefs.server;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.jboss.jbossas.servermanager.Server;
import org.jboss.jbossas.servermanager.ServerManager;

public class ConfigManagerTask
extends Task {
    protected static final String MANAGER_REF = "serverManager";
    static ServerManager manager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigManagerTask() {
        if (manager == null) {
            Thread curThread = Thread.currentThread();
            ClassLoader orgCl = curThread.getContextClassLoader();
            curThread.setContextClassLoader(ConfigManagerTask.getClassLoader());
            try {
                manager = new ServerManager();
            }
            finally {
                curThread.setContextClassLoader(orgCl);
            }
        }
    }

    public void execute() throws BuildException {
        if (this.getProject().getReference(MANAGER_REF) == null) {
            this.getProject().addReference(MANAGER_REF, (Object)manager);
        }
    }

    protected static ServerManager getServerManager(Project project) {
        ServerManager manager = (ServerManager)project.getReference(MANAGER_REF);
        if (manager == null) {
            throw new BuildException("Can't find reference to server manager. Consider context you execute server tasks.");
        }
        return manager;
    }

    protected static ClassLoader getClassLoader() {
        return ServerManager.class.getClassLoader();
    }

    public void addServer(Server server) {
        manager.addServer(server);
    }

    public void setJavaHome(String javaHome) {
        manager.setJavaHome(javaHome);
    }

    public void setJbossHome(String jbossHome) {
        manager.setJbossHome(jbossHome);
    }

    public void setJvm(String jvm) {
        manager.setJvm(jvm);
    }

    public void setUdpGroup(String udpGroup) {
        manager.setUdpGroup(udpGroup);
    }
}

