/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.ant.taskdefs.server;

import java.io.IOException;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.jboss.jbossas.servermanager.ServerManager;
import org.jboss.jbossas.servermanager.ServerShutdownException;


/**
 * A StopServerTask.
 * 
 * @author <a href="ryan.campbell@jboss.com">Ryan Campbell</a>
 * @version $Revision: 80346 $
 */
public class StopServerTask extends Task
{

   private String name;

   private boolean failonerror = false;
   private boolean ignoreerrors = false;

   /**
    * Stop the server.
    */

   public void execute() throws BuildException
   {
      // set TCL and save the original TCL to restore it later
      Thread curThread = Thread.currentThread();
      ClassLoader orgCl = curThread.getContextClassLoader();
      curThread.setContextClassLoader(ConfigManagerTask.getClassLoader());

      // Stop server with the correct TCL.
      try
      {
         stopServer();
      }
      finally
      {
         curThread.setContextClassLoader(orgCl);
      }
   }

   public void stopServer() throws BuildException
   {
      ServerManager manager = ConfigManagerTask.getServerManager(getProject());
      try
      {
         manager.stopServer(name);
      }
      catch (IOException e)
      {
                        if (e instanceof ServerShutdownException && ignoreerrors)
                        {
                           // do nothing
                        }
			else if (e instanceof ServerShutdownException && !failonerror)
			{
				log("Unable to shutdown server properly: " + e, Project.MSG_ERR);
			}
			else
			{
				throw new BuildException("Error stopping server \"" + name + "\": " + e.toString(), e);
			}
      }
   }

   /**
    * Set the name.
    * 
    * @param name The name to set.
    */
   public void setName(String name)
   {
      this.name = name;
   }

   /**
    * Set failonerror to fail build rather than only log the error.
    *
    * @param failonerror Choice to set.
    */
   public void setFailOnError(boolean flag)
   {
      this.failonerror = flag;
   }

   /**
    * Set ignoreerrors to silently ignore server shutdown errors.
    * 
    * @param ignoreerrors Choice to set.
    */
   public void setIgnoreErrors(boolean flag)
   {
      this.ignoreerrors = flag;
   }
}
