/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.Configuration;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.NotLoggedInException;
import org.jboss.seam.security.RememberMe;
import org.jboss.seam.security.Role;
import org.jboss.seam.security.RunAsOperation;
import org.jboss.seam.security.SimpleGroup;
import org.jboss.seam.security.permission.PermissionMapper;
import org.jboss.seam.web.Session;

@Name(value="org.jboss.seam.security.identity")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0)
@BypassInterceptors
@Startup
public class Identity
implements Serializable {
    private static final long serialVersionUID = 3751659008033189259L;
    public static final String EVENT_LOGIN_SUCCESSFUL = "org.jboss.seam.security.loginSuccessful";
    public static final String EVENT_LOGIN_FAILED = "org.jboss.seam.security.loginFailed";
    public static final String EVENT_NOT_LOGGED_IN = "org.jboss.seam.security.notLoggedIn";
    public static final String EVENT_NOT_AUTHORIZED = "org.jboss.seam.security.notAuthorized";
    public static final String EVENT_PRE_AUTHENTICATE = "org.jboss.seam.security.preAuthenticate";
    public static final String EVENT_POST_AUTHENTICATE = "org.jboss.seam.security.postAuthenticate";
    public static final String EVENT_LOGGED_OUT = "org.jboss.seam.security.loggedOut";
    public static final String EVENT_ALREADY_LOGGED_IN = "org.jboss.seam.security.alreadyLoggedIn";
    public static final String EVENT_QUIET_LOGIN = "org.jboss.seam.security.quietLogin";
    protected static boolean securityEnabled = true;
    public static final String ROLES_GROUP = "Roles";
    private static final String LOGIN_TRIED = "org.jboss.seam.security.loginTried";
    private static final String SILENT_LOGIN = "org.jboss.seam.security.silentLogin";
    private static final LogProvider log = Logging.getLogProvider(Identity.class);
    private Credentials credentials;
    private Expressions.MethodExpression authenticateMethod;
    private Principal principal;
    private Subject subject;
    private RememberMe rememberMe;
    private transient ThreadLocal<Boolean> systemOp;
    private String jaasConfigName = null;
    private List<String> preAuthenticationRoles = new ArrayList<String>();
    private PermissionMapper permissionMapper;
    private boolean authenticating = false;

    @Create
    public void create() {
        this.subject = new Subject();
        if (Contexts.isApplicationContextActive()) {
            this.permissionMapper = (PermissionMapper)Component.getInstance(PermissionMapper.class);
        }
        if (Contexts.isSessionContextActive()) {
            this.rememberMe = (RememberMe)Component.getInstance(RememberMe.class, true);
            this.credentials = (Credentials)Component.getInstance(Credentials.class);
        }
        if (this.credentials == null) {
            this.credentials = new Credentials();
        }
    }

    public static boolean isSecurityEnabled() {
        return securityEnabled;
    }

    public static void setSecurityEnabled(boolean enabled) {
        securityEnabled = enabled;
    }

    public static Identity instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        Identity instance = (Identity)Component.getInstance(Identity.class, ScopeType.SESSION);
        if (instance == null) {
            throw new IllegalStateException("No Identity could be created");
        }
        return instance;
    }

    public boolean isLoggedIn() {
        return this.getPrincipal() != null;
    }

    public boolean tryLogin() {
        if (!this.authenticating && this.getPrincipal() == null && this.credentials.isSet() && Contexts.isEventContextActive() && !Contexts.getEventContext().isSet(LOGIN_TRIED)) {
            Contexts.getEventContext().set(LOGIN_TRIED, true);
            this.quietLogin();
        }
        return this.isLoggedIn();
    }

    @Deprecated
    public boolean isLoggedIn(boolean attemptLogin) {
        return attemptLogin ? this.tryLogin() : this.isLoggedIn();
    }

    public void acceptExternallyAuthenticatedPrincipal(Principal principal) {
        this.getSubject().getPrincipals().add(principal);
        this.principal = principal;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void checkRestriction(String expr) {
        if (!securityEnabled) {
            return;
        }
        if (!this.evaluateExpression(expr)) {
            if (!this.isLoggedIn()) {
                if (Events.exists()) {
                    Events.instance().raiseEvent(EVENT_NOT_LOGGED_IN, new Object[0]);
                }
                log.debug(String.format("Error evaluating expression [%s] - User not logged in", expr));
                throw new NotLoggedInException();
            }
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_NOT_AUTHORIZED, new Object[0]);
            }
            throw new AuthorizationException(String.format("Authorization check failed for expression [%s]", expr));
        }
    }

    public String login() {
        try {
            if (this.isLoggedIn()) {
                if (Contexts.isEventContextActive() && Contexts.getEventContext().isSet(SILENT_LOGIN)) {
                    if (Events.exists()) {
                        Events.instance().raiseEvent(EVENT_LOGIN_SUCCESSFUL, new Object[0]);
                    }
                    return "loggedIn";
                }
                if (Events.exists()) {
                    Events.instance().raiseEvent(EVENT_ALREADY_LOGGED_IN, new Object[0]);
                }
                return "loggedIn";
            }
            this.authenticate();
            if (!this.isLoggedIn()) {
                throw new LoginException();
            }
            if (log.isDebugEnabled()) {
                log.debug("Login successful for: " + this.getCredentials().getUsername());
            }
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_LOGIN_SUCCESSFUL, new Object[0]);
            }
            return "loggedIn";
        }
        catch (LoginException ex) {
            this.credentials.invalidate();
            if (log.isDebugEnabled()) {
                log.debug("Login failed for: " + this.getCredentials().getUsername(), ex);
            }
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_LOGIN_FAILED, ex);
            }
            return null;
        }
    }

    public void quietLogin() {
        try {
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_QUIET_LOGIN, new Object[0]);
            }
            if (!this.isLoggedIn() && this.credentials.isSet()) {
                this.authenticate();
                if (this.isLoggedIn() && Contexts.isEventContextActive()) {
                    Contexts.getEventContext().set(SILENT_LOGIN, true);
                }
            }
        }
        catch (LoginException ex) {
            this.credentials.invalidate();
        }
    }

    public synchronized void authenticate() throws LoginException {
        if (!this.isLoggedIn() && !this.credentials.isInvalid()) {
            this.principal = null;
            this.subject = new Subject();
            this.authenticate(this.getLoginContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticate(LoginContext loginContext) throws LoginException {
        try {
            this.authenticating = true;
            this.preAuthenticate();
            loginContext.login();
            this.postAuthenticate();
        }
        finally {
            this.credentials.setPassword(null);
            this.authenticating = false;
        }
    }

    protected void preAuthenticate() {
        this.preAuthenticationRoles.clear();
        if (Events.exists()) {
            Events.instance().raiseEvent(EVENT_PRE_AUTHENTICATE, new Object[0]);
        }
    }

    protected void postAuthenticate() {
        for (Principal p : this.getSubject().getPrincipals()) {
            if (p instanceof Group || this.principal != null) continue;
            this.principal = p;
            break;
        }
        if (!this.preAuthenticationRoles.isEmpty() && this.isLoggedIn()) {
            for (String role : this.preAuthenticationRoles) {
                this.addRole(role);
            }
            this.preAuthenticationRoles.clear();
        }
        this.credentials.setPassword(null);
        if (Events.exists()) {
            Events.instance().raiseEvent(EVENT_POST_AUTHENTICATE, this);
        }
    }

    public void unAuthenticate() {
        this.principal = null;
        this.subject = new Subject();
        this.credentials.clear();
    }

    protected LoginContext getLoginContext() throws LoginException {
        if (this.getJaasConfigName() != null) {
            return new LoginContext(this.getJaasConfigName(), this.getSubject(), this.credentials.createCallbackHandler());
        }
        return new LoginContext("default", this.getSubject(), this.credentials.createCallbackHandler(), Configuration.instance());
    }

    public void logout() {
        if (this.isLoggedIn()) {
            this.unAuthenticate();
            Session.instance().invalidate();
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_LOGGED_OUT, new Object[0]);
            }
        }
    }

    public boolean hasRole(String role) {
        if (!securityEnabled) {
            return true;
        }
        if (this.systemOp != null && Boolean.TRUE.equals(this.systemOp.get())) {
            return true;
        }
        this.tryLogin();
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            return sg.isMember((Principal)new Role(role));
        }
        return false;
    }

    public boolean addRole(String role) {
        if (role == null || "".equals(role)) {
            return false;
        }
        if (!this.isLoggedIn()) {
            this.preAuthenticationRoles.add(role);
            return false;
        }
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            return sg.addMember((Principal)new Role(role));
        }
        SimpleGroup roleGroup = new SimpleGroup(ROLES_GROUP);
        roleGroup.addMember(new Role(role));
        this.getSubject().getPrincipals().add((Principal)((Object)roleGroup));
        return true;
    }

    public void removeRole(String role) {
        block0: for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            Enumeration e = sg.members();
            while (e.hasMoreElements()) {
                Principal member = (Principal)e.nextElement();
                if (!member.getName().equals(role)) continue;
                sg.removeMember(member);
                continue block0;
            }
        }
    }

    public void checkRole(String role) {
        this.tryLogin();
        if (!this.hasRole(role)) {
            if (!this.isLoggedIn()) {
                if (Events.exists()) {
                    Events.instance().raiseEvent(EVENT_NOT_LOGGED_IN, new Object[0]);
                }
                throw new NotLoggedInException();
            }
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_NOT_AUTHORIZED, new Object[0]);
            }
            throw new AuthorizationException(String.format("Authorization check failed for role [%s]", role));
        }
    }

    public void checkPermission(String name, String action, Object ... arg) {
        if (this.systemOp != null && Boolean.TRUE.equals(this.systemOp.get())) {
            return;
        }
        this.tryLogin();
        if (!this.hasPermission(name, action, arg)) {
            if (!this.isLoggedIn()) {
                if (Events.exists()) {
                    Events.instance().raiseEvent(EVENT_NOT_LOGGED_IN, new Object[0]);
                }
                throw new NotLoggedInException();
            }
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_NOT_AUTHORIZED, new Object[0]);
            }
            throw new AuthorizationException(String.format("Authorization check failed for permission [%s,%s]", name, action));
        }
    }

    public void checkPermission(Object target, String action) {
        if (this.systemOp != null && Boolean.TRUE.equals(this.systemOp.get())) {
            return;
        }
        this.tryLogin();
        if (!this.hasPermission(target, action)) {
            if (!this.isLoggedIn()) {
                if (Events.exists()) {
                    Events.instance().raiseEvent(EVENT_NOT_LOGGED_IN, new Object[0]);
                }
                throw new NotLoggedInException();
            }
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_NOT_AUTHORIZED, new Object[0]);
            }
            throw new AuthorizationException(String.format("Authorization check failed for permission[%s,%s]", target, action));
        }
    }

    public boolean hasPermission(String name, String action, Object ... arg) {
        if (!securityEnabled) {
            return true;
        }
        if (this.systemOp != null && Boolean.TRUE.equals(this.systemOp.get())) {
            return true;
        }
        if (this.permissionMapper == null) {
            return false;
        }
        if (arg != null) {
            return this.permissionMapper.resolvePermission(arg[0], action);
        }
        return this.permissionMapper.resolvePermission(name, action);
    }

    public void filterByPermission(Collection collection, String action) {
        this.permissionMapper.filterByPermission(collection, action);
    }

    public boolean hasPermission(Object target, String action) {
        if (!securityEnabled) {
            return true;
        }
        if (this.systemOp != null && Boolean.TRUE.equals(this.systemOp.get())) {
            return true;
        }
        if (this.permissionMapper == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.permissionMapper.resolvePermission(target, action);
    }

    protected boolean evaluateExpression(String expr) {
        return Expressions.instance().createValueExpression(expr, Boolean.class).getValue();
    }

    @Deprecated
    public String getUsername() {
        return this.credentials.getUsername();
    }

    @Deprecated
    public void setUsername(String username) {
        this.credentials.setUsername(username);
    }

    @Deprecated
    public String getPassword() {
        return this.credentials.getPassword();
    }

    @Deprecated
    public void setPassword(String password) {
        this.credentials.setPassword(password);
    }

    @Deprecated
    public boolean isRememberMe() {
        return this.rememberMe != null ? this.rememberMe.isEnabled() : false;
    }

    @Deprecated
    public void setRememberMe(boolean remember) {
        if (this.rememberMe != null) {
            this.rememberMe.setEnabled(remember);
        }
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Expressions.MethodExpression getAuthenticateMethod() {
        return this.authenticateMethod;
    }

    public void setAuthenticateMethod(Expressions.MethodExpression authMethod) {
        this.authenticateMethod = authMethod;
    }

    public String getJaasConfigName() {
        return this.jaasConfigName;
    }

    public void setJaasConfigName(String jaasConfigName) {
        this.jaasConfigName = jaasConfigName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void runAs(RunAsOperation operation) {
        Principal savedPrincipal = this.getPrincipal();
        Subject savedSubject = this.getSubject();
        try {
            this.principal = operation.getPrincipal();
            this.subject = operation.getSubject();
            if (this.systemOp == null) {
                this.systemOp = new ThreadLocal();
            }
            this.systemOp.set(operation.isSystemOperation());
            operation.execute();
        }
        finally {
            this.systemOp.set(false);
            this.principal = savedPrincipal;
            this.subject = savedSubject;
        }
    }
}

