/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import javax.security.auth.login.LoginException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.international.StatusMessages;
import org.jboss.seam.security.Identity;

@Name(value="org.jboss.seam.security.facesSecurityEvents")
@Scope(value=ScopeType.APPLICATION)
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
@BypassInterceptors
@Startup
public class FacesSecurityEvents {
    @Observer(value={"org.jboss.seam.security.postAuthenticate"})
    public void postAuthenticate(Identity identity) {
    }

    @Observer(value={"org.jboss.seam.security.loginFailed"})
    public void addLoginFailedMessage(LoginException ex) {
        StatusMessages.instance().addFromResourceBundleOrDefault(this.getLoginFailedMessageSeverity(), this.getLoginFailedMessageKey(), this.getLoginFailedMessage(), ex);
    }

    public String getLoginFailedMessage() {
        return "Login failed";
    }

    public StatusMessage.Severity getLoginFailedMessageSeverity() {
        return StatusMessage.Severity.INFO;
    }

    public String getLoginFailedMessageKey() {
        return "org.jboss.seam.loginFailed";
    }

    @Observer(value={"org.jboss.seam.security.loginSuccessful"})
    public void addLoginSuccessfulMessage() {
        StatusMessages.instance().addFromResourceBundleOrDefault(this.getLoginSuccessfulMessageSeverity(), this.getLoginSuccessfulMessageKey(), this.getLoginSuccessfulMessage(), Identity.instance().getCredentials().getUsername());
    }

    @Observer(value={"org.jboss.seam.security.notLoggedIn"})
    public void addNotLoggedInMessage() {
        StatusMessages.instance().addFromResourceBundleOrDefault(StatusMessage.Severity.WARN, "org.jboss.seam.NotLoggedIn", "Please log in first", new Object[0]);
    }

    public StatusMessage.Severity getLoginSuccessfulMessageSeverity() {
        return StatusMessage.Severity.INFO;
    }

    public String getLoginSuccessfulMessage() {
        return "Welcome, #0";
    }

    public String getLoginSuccessfulMessageKey() {
        return "org.jboss.seam.loginSuccessful";
    }

    @Observer(value={"org.jboss.seam.security.alreadyLoggedIn"})
    public void addAlreadyLoggedInMessage() {
        StatusMessages.instance().addFromResourceBundleOrDefault(StatusMessage.Severity.WARN, "org.jboss.seam.AlreadyLoggedIn", "You are already logged in, please log out first if you wish to log in again", new Object[0]);
    }
}

