/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.util.ReflectHelper;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.security.HibernateSecurityInterceptor;
import org.jboss.seam.util.Naming;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Startup
public class HibernateSessionFactory {
    private SessionFactory sessionFactory;
    private String cfgResourceName;
    private Map<String, String> cfgProperties;
    private List<String> mappingClasses;
    private List<String> mappingFiles;
    private List<String> mappingJars;
    private List<String> mappingPackages;
    private List<String> mappingResources;
    private NamingStrategy namingStrategy;

    @Unwrap
    public SessionFactory getSessionFactory() throws Exception {
        return this.sessionFactory;
    }

    @Create
    public void startup() throws Exception {
        this.sessionFactory = this.createSessionFactory();
    }

    @Destroy
    public void shutdown() {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
    }

    protected SessionFactory createSessionFactory() throws ClassNotFoundException {
        Hashtable jndiProperties;
        AnnotationConfiguration configuration = new AnnotationConfiguration();
        if (this.namingStrategy != null) {
            configuration.setNamingStrategy(this.namingStrategy);
        }
        if (this.cfgProperties != null) {
            Properties props = new Properties();
            props.putAll(this.cfgProperties);
            configuration.setProperties(props);
        }
        if ((jndiProperties = Naming.getInitialContextProperties()) != null) {
            for (Map.Entry entry : jndiProperties.entrySet()) {
                configuration.setProperty("hibernate.jndi." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.cfgProperties == null && this.cfgResourceName == null) {
            configuration.configure();
        } else if (this.cfgProperties == null && this.cfgResourceName != null) {
            configuration.configure(this.cfgResourceName);
        }
        if (this.mappingClasses != null) {
            for (String className : this.mappingClasses) {
                configuration.addAnnotatedClass(ReflectHelper.classForName((String)className));
            }
        }
        if (this.mappingFiles != null) {
            for (String fileName : this.mappingFiles) {
                configuration.addFile(fileName);
            }
        }
        if (this.mappingJars != null) {
            for (String jarName : this.mappingJars) {
                configuration.addJar(new File(jarName));
            }
        }
        if (this.mappingPackages != null) {
            for (String packageName : this.mappingPackages) {
                configuration.addPackage(packageName);
            }
        }
        if (this.mappingResources != null) {
            for (String resourceName : this.mappingResources) {
                configuration.addResource(resourceName);
            }
        }
        configuration.setInterceptor((Interceptor)new HibernateSecurityInterceptor(configuration.getInterceptor()));
        return configuration.buildSessionFactory();
    }

    public String getCfgResourceName() {
        return this.cfgResourceName;
    }

    public void setCfgResourceName(String cfgFileName) {
        this.cfgResourceName = cfgFileName;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public Map<String, String> getCfgProperties() {
        return this.cfgProperties;
    }

    public void setCfgProperties(Map<String, String> cfgProperties) {
        this.cfgProperties = cfgProperties;
    }

    public List<String> getMappingClasses() {
        return this.mappingClasses;
    }

    public void setMappingClasses(List<String> mappingClasses) {
        this.mappingClasses = mappingClasses;
    }

    public List<String> getMappingFiles() {
        return this.mappingFiles;
    }

    public void setMappingFiles(List<String> mappingFiles) {
        this.mappingFiles = mappingFiles;
    }

    public List<String> getMappingJars() {
        return this.mappingJars;
    }

    public void setMappingJars(List<String> mappingJars) {
        this.mappingJars = mappingJars;
    }

    public List<String> getMappingPackages() {
        return this.mappingPackages;
    }

    public void setMappingPackages(List<String> mappingPackages) {
        this.mappingPackages = mappingPackages;
    }

    public List<String> getMappingResources() {
        return this.mappingResources;
    }

    public void setMappingResources(List<String> mappingResources) {
        this.mappingResources = mappingResources;
    }
}

