/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.resteasy.annotations.Stream;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.providers.sse.SseImpl;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.AsyncResponseProvider;
import org.jboss.resteasy.spi.AsyncStreamProvider;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AsyncResponseConsumer {
    protected Map<Class<?>, Object> contextDataMap;
    protected ResourceMethodInvoker method;
    protected SynchronousDispatcher dispatcher;
    protected ResteasyAsynchronousResponse asyncResponse;
    protected boolean isComplete;

    public AsyncResponseConsumer(ResourceMethodInvoker method) {
        this.method = method;
        this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
        this.dispatcher = (SynchronousDispatcher)this.contextDataMap.get(Dispatcher.class);
        HttpRequest httpRequest = (HttpRequest)this.contextDataMap.get(HttpRequest.class);
        this.asyncResponse = httpRequest.getAsyncContext().isSuspended() ? httpRequest.getAsyncContext().getAsyncResponse() : httpRequest.getAsyncContext().suspend();
    }

    public static AsyncResponseConsumer makeAsyncResponseConsumer(ResourceMethodInvoker method, AsyncResponseProvider<?> asyncResponseProvider) {
        return new CompletionStageResponseConsumer(method, asyncResponseProvider);
    }

    public static AsyncResponseConsumer makeAsyncResponseConsumer(ResourceMethodInvoker method, AsyncStreamProvider<?> asyncStreamProvider) {
        if (method.isSse()) {
            return new AsyncStreamSseResponseConsumer(method, asyncStreamProvider);
        }
        for (Annotation annotation : method.getMethodAnnotations()) {
            if (annotation.annotationType() != Stream.class) continue;
            return new AsyncStreamingResponseConsumer(method, asyncStreamProvider);
        }
        return new AsyncStreamCollectorResponseConsumer(method, asyncStreamProvider);
    }

    protected void doComplete() {
        this.asyncResponse.complete();
    }

    public final synchronized void complete(Throwable t) {
        if (!this.isComplete) {
            this.isComplete = true;
            this.doComplete();
            this.asyncResponse.completionCallbacks(t);
            ResteasyProviderFactory.removeContextDataLevel();
        }
    }

    protected void internalResume(Object entity, Consumer<Throwable> onComplete) {
        ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
        HttpRequest httpRequest = (HttpRequest)this.contextDataMap.get(HttpRequest.class);
        HttpResponse httpResponse = (HttpResponse)this.contextDataMap.get(HttpResponse.class);
        BuiltResponse builtResponse = this.createResponse(entity, httpRequest);
        try {
            this.sendBuiltResponse(builtResponse, httpRequest, httpResponse, e -> {
                if (e != null) {
                    this.exceptionWhileResuming((Throwable)e);
                }
                onComplete.accept((Throwable)e);
            });
        }
        catch (IOException e2) {
            onComplete.accept(e2);
            this.exceptionWhileResuming(e2);
        }
    }

    private void exceptionWhileResuming(Throwable e) {
        try {
            this.internalResume(e, (Throwable t) -> {});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.complete(e);
    }

    protected void sendBuiltResponse(BuiltResponse builtResponse, HttpRequest httpRequest, HttpResponse httpResponse, Consumer<Throwable> onComplete) throws IOException {
        boolean sendHeaders = this.sendHeaders();
        ServerResponseWriter.writeNomapResponse(builtResponse, httpRequest, httpResponse, this.dispatcher.getProviderFactory(), onComplete, sendHeaders);
    }

    protected abstract boolean sendHeaders();

    protected void internalResume(Throwable t, Consumer<Throwable> onComplete) {
        ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
        HttpRequest httpRequest = (HttpRequest)this.contextDataMap.get(HttpRequest.class);
        HttpResponse httpResponse = (HttpResponse)this.contextDataMap.get(HttpResponse.class);
        this.dispatcher.writeException(httpRequest, httpResponse, t, onComplete);
    }

    protected BuiltResponse createResponse(Object entity, HttpRequest httpRequest) {
        BuiltResponse builtResponse = null;
        if (entity == null) {
            builtResponse = (BuiltResponse)Response.noContent().build();
        } else if (entity instanceof BuiltResponse) {
            builtResponse = (BuiltResponse)((Object)entity);
        } else if (entity instanceof Response) {
            Response r = (Response)entity;
            Headers<Object> metadata = new Headers<Object>();
            metadata.putAll(r.getMetadata());
            builtResponse = new BuiltResponse(r.getStatus(), r.getStatusInfo().getReasonPhrase(), metadata, r.getEntity(), this.method.getMethodAnnotations());
        } else {
            if (this.method == null) {
                throw new IllegalStateException(Messages.MESSAGES.unknownMediaTypeResponseEntity());
            }
            BuiltResponse jaxrsResponse = (BuiltResponse)Response.ok((Object)entity).build();
            Type unwrappedType = ((ParameterizedType)this.method.getGenericReturnType()).getActualTypeArguments()[0];
            Type newType = this.adaptGenericType(unwrappedType);
            jaxrsResponse.setGenericType(newType);
            jaxrsResponse.addMethodAnnotations(this.method.getMethodAnnotations());
            builtResponse = jaxrsResponse;
        }
        return builtResponse;
    }

    protected Type adaptGenericType(Type unwrappedType) {
        return unwrappedType;
    }

    public abstract void subscribe(Object var1);

    private static class AsyncStreamSseResponseConsumer
    extends AsyncStreamResponseConsumer {
        private SseImpl sse = new SseImpl();
        private SseEventSink sseEventSink = ResteasyProviderFactory.getContextData(SseEventSink.class);
        private volatile boolean onCompleteReceived = false;
        private volatile boolean sendingEvent = false;

        private AsyncStreamSseResponseConsumer(ResourceMethodInvoker method, AsyncStreamProvider<?> asyncStreamProvider) {
            super(method, asyncStreamProvider);
        }

        @Override
        protected void doComplete() {
            this.subscription.cancel();
            this.sseEventSink.close();
        }

        @Override
        protected void addNextElement(Object element) {
            super.addNextElement(element);
        }

        @Override
        public synchronized void onComplete() {
            this.onCompleteReceived = true;
            if (!this.sendingEvent) {
                super.onComplete();
            }
        }

        @Override
        protected void sendBuiltResponse(BuiltResponse builtResponse, HttpRequest httpRequest, HttpResponse httpResponse, Consumer<Throwable> onComplete) {
            ServerResponseWriter.setResponseMediaType(builtResponse, httpRequest, httpResponse, this.dispatcher.getProviderFactory(), this.method);
            OutboundSseEvent event = this.sse.newEventBuilder().mediaType(builtResponse.getMediaType()).data(builtResponse.getEntityClass(), builtResponse.getEntity()).build();
            this.sendingEvent = true;
            try {
                this.sseEventSink.send(event).whenComplete((val, ex) -> {
                    AsyncStreamSseResponseConsumer asyncStreamSseResponseConsumer = this;
                    synchronized (asyncStreamSseResponseConsumer) {
                        this.sendingEvent = false;
                        if (this.onCompleteReceived) {
                            super.onComplete();
                        } else if (ex != null) {
                            this.complete((Throwable)ex);
                            onComplete.accept((Throwable)ex);
                        } else {
                            this.subscription.request(1L);
                            onComplete.accept((Throwable)ex);
                        }
                    }
                });
            }
            catch (Exception x) {
                this.complete(x);
                onComplete.accept(x);
            }
        }

        @Override
        protected boolean sendHeaders() {
            return false;
        }
    }

    private static class AsyncStreamCollectorResponseConsumer
    extends AsyncStreamResponseConsumer {
        private List<Object> collector = new ArrayList<Object>();

        public AsyncStreamCollectorResponseConsumer(ResourceMethodInvoker method, AsyncStreamProvider<?> asyncStreamProvider) {
            super(method, asyncStreamProvider);
        }

        @Override
        protected boolean sendHeaders() {
            return true;
        }

        @Override
        protected void addNextElement(Object element) {
            this.collector.add(element);
            this.subscription.request(1L);
        }

        @Override
        public void onComplete() {
            this.internalResume(this.collector, (Throwable t) -> this.complete((Throwable)t));
        }

        @Override
        protected Type adaptGenericType(final Type unwrappedType) {
            return new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{unwrappedType};
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }

                @Override
                public Type getRawType() {
                    return List.class;
                }
            };
        }
    }

    private static class AsyncStreamingResponseConsumer
    extends AsyncStreamResponseConsumer {
        private boolean sentEntity;

        public AsyncStreamingResponseConsumer(ResourceMethodInvoker method, AsyncStreamProvider<?> asyncStreamProvider) {
            super(method, asyncStreamProvider);
        }

        @Override
        protected void sendBuiltResponse(BuiltResponse builtResponse, HttpRequest httpRequest, HttpResponse httpResponse, Consumer<Throwable> onComplete) throws IOException {
            super.sendBuiltResponse(builtResponse, httpRequest, httpResponse, onComplete);
            this.sentEntity = true;
        }

        @Override
        protected void addNextElement(Object element) {
            this.internalResume(element, (Throwable t) -> {
                if (t != null) {
                    this.complete((Throwable)t);
                } else {
                    this.subscription.request(1L);
                }
            });
        }

        @Override
        protected boolean sendHeaders() {
            return !this.sentEntity;
        }
    }

    private static abstract class AsyncStreamResponseConsumer
    extends AsyncResponseConsumer
    implements Subscriber<Object> {
        protected Subscription subscription;
        private AsyncStreamProvider<?> asyncStreamProvider;

        public AsyncStreamResponseConsumer(ResourceMethodInvoker method, AsyncStreamProvider<?> asyncStreamProvider) {
            super(method);
            this.asyncStreamProvider = asyncStreamProvider;
        }

        @Override
        protected void doComplete() {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
            super.doComplete();
        }

        public void onComplete() {
            this.complete(null);
        }

        public void onError(Throwable t) {
            this.internalResume(t, (Throwable x) -> this.complete(t));
        }

        protected void addNextElement(Object element) {
            this.internalResume(element, (Throwable t) -> {
                if (t != null) {
                    this.complete((Throwable)t);
                }
            });
        }

        public void onNext(Object v) {
            this.addNextElement(v);
        }

        public void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            subscription.request(1L);
        }

        @Override
        public void subscribe(Object rtn) {
            Publisher stage = this.asyncStreamProvider.toAsyncStream(rtn);
            stage.subscribe((Subscriber)this);
        }
    }

    private static class CompletionStageResponseConsumer
    extends AsyncResponseConsumer
    implements BiConsumer<Object, Throwable> {
        private AsyncResponseProvider<?> asyncResponseProvider;

        public CompletionStageResponseConsumer(ResourceMethodInvoker method, AsyncResponseProvider<?> asyncResponseProvider) {
            super(method);
            this.asyncResponseProvider = asyncResponseProvider;
        }

        @Override
        protected boolean sendHeaders() {
            return true;
        }

        @Override
        public void accept(Object t, Throwable u) {
            if (t != null || u == null) {
                this.internalResume(t, (Throwable x) -> this.complete(null));
            } else {
                this.internalResume(u, (Throwable x) -> this.complete(u));
            }
        }

        @Override
        public void subscribe(Object rtn) {
            CompletionStage stage = this.asyncResponseProvider.toCompletionStage(rtn);
            stage.whenComplete(this);
        }
    }
}

