/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.touri;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.spi.touri.URIResolver;
import org.jboss.resteasy.util.AnnotationResolver;

public abstract class AbstractURITemplateAnnotationResolver
implements URIResolver {
    public boolean handles(Class type) {
        return AnnotationResolver.getClassWithAnnotation(type, this.getAnnotationType()) != null;
    }

    @Override
    public String resolveURI(Object object) {
        Class clazz = AnnotationResolver.getClassWithAnnotation(object.getClass(), this.getAnnotationType());
        UriBuilderImpl uriBuilderImpl = this.getUriBuilder(clazz);
        Map<String, PropertyDescriptor> descriptors = this.getPropertyDescriptors(clazz);
        List<Object> values = this.getValues(object, descriptors, uriBuilderImpl.getPathParamNamesInDeclarationOrder());
        return uriBuilderImpl.build(values.toArray()).toString();
    }

    protected abstract Class<? extends Annotation> getAnnotationType();

    protected abstract UriBuilderImpl getUriBuilder(Class<? extends Object> var1);

    private List<Object> getValues(Object object, Map<String, PropertyDescriptor> descriptors, List<String> params) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String param : params) {
            PropertyDescriptor propertyDescriptor = descriptors.get(param);
            if (propertyDescriptor == null) {
                throw new RuntimeException("URITemplateAnnotationResolver could not find a getter for param " + param);
            }
            Method readMethod = propertyDescriptor.getReadMethod();
            if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                readMethod.setAccessible(true);
            }
            try {
                values.add(readMethod.invoke(object, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("URITemplateAnnotationResolver could not get a value for " + param, e);
            }
        }
        return values;
    }

    private Map<String, PropertyDescriptor> getPropertyDescriptors(Class<? extends Object> clazz) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            HashMap<String, PropertyDescriptor> results = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                results.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            return results;
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("URITemplateAnnotationResolver could not introspect class " + clazz.getName(), e);
        }
    }
}

