/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.util.AcceptParser;

@ConstrainedTo(value=ConstrainedTo.Type.SERVER)
@BindingPriority(value=5000)
public class ServerContentEncodingAnnotationFilter
implements WriterInterceptor {
    @Context
    protected HttpRequest request;
    Set<String> encodings;

    public ServerContentEncodingAnnotationFilter(Set<String> encodings) {
        this.encodings = encodings;
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        List acceptEncoding = (List)this.request.getHttpHeaders().getRequestHeaders().get((Object)"Accept-Encoding");
        if (acceptEncoding != null) {
            StringBuffer buf = new StringBuffer();
            for (String accept : acceptEncoding) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(accept);
            }
            List<String> accepts = AcceptParser.parseAcceptHeader(buf.toString());
            for (String encoding : accepts) {
                if (!this.encodings.contains(encoding.toLowerCase())) continue;
                context.getHeaders().putSingle((Object)"Content-Encoding", (Object)encoding);
                break;
            }
        }
        context.proceed();
    }
}

