/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.NameBinding;
import javax.ws.rs.container.PreMatching;
import org.jboss.resteasy.core.interception.JaxrsInterceptorRegistryListener;
import org.jboss.resteasy.core.interception.LegacyPrecedence;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.AcceptedByMethod;

public class JaxrsInterceptorRegistry<T> {
    protected List<InterceptorFactory> interceptors = new ArrayList<InterceptorFactory>();
    protected List<JaxrsInterceptorRegistryListener> listeners = new ArrayList<JaxrsInterceptorRegistryListener>();
    protected ResteasyProviderFactory providerFactory;
    protected Class<T> intf;

    protected static List<Class<? extends Annotation>> getNameBound(Class<?> declaring) {
        ArrayList<Class<? extends Annotation>> nameBound = new ArrayList<Class<? extends Annotation>>();
        for (Annotation annotation : declaring.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(NameBinding.class) || nameBound != null) continue;
            nameBound.add(annotation.annotationType());
        }
        return nameBound;
    }

    public static int getBindingPriority(Class<?> declaring) {
        BindingPriority priority = declaring.getAnnotation(BindingPriority.class);
        if (priority != null) {
            return priority.value();
        }
        return 7000;
    }

    public JaxrsInterceptorRegistry(ResteasyProviderFactory providerFactory, Class<T> intf) {
        this.providerFactory = providerFactory;
        this.intf = intf;
    }

    public JaxrsInterceptorRegistry<T> clone(ResteasyProviderFactory factory) {
        JaxrsInterceptorRegistry<T> clone = new JaxrsInterceptorRegistry<T>(factory, this.intf);
        clone.interceptors.addAll(this.interceptors);
        return clone;
    }

    public Class<T> getIntf() {
        return this.intf;
    }

    public List<JaxrsInterceptorRegistryListener> getListeners() {
        return this.listeners;
    }

    public T[] preMatch() {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (InterceptorFactory factory : this.interceptors) {
            Match match = factory.preMatch();
            if (match == null) continue;
            matches.add(match);
        }
        return this.createArray(matches);
    }

    public T[] postMatch(Class declaring, AccessibleObject target) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (InterceptorFactory factory : this.interceptors) {
            Match match = factory.postMatch(declaring, target);
            if (match == null) continue;
            matches.add(match);
        }
        return this.createArray(matches);
    }

    private T[] createArray(List<Match> matches) {
        Collections.sort(matches, new PrecedenceComparator());
        Object[] array = (Object[])Array.newInstance(this.intf, matches.size());
        for (int i = 0; i < array.length; ++i) {
            array[i] = matches.get((int)i).interceptor;
        }
        return array;
    }

    public void register(InterceptorFactory factory) {
        this.interceptors.add(factory);
        for (JaxrsInterceptorRegistryListener listener : this.listeners) {
            listener.registryUpdated(this);
        }
    }

    public void registerClass(Class<? extends T> declaring) {
        this.register(new OnDemandInterceptorFactory(declaring));
    }

    public void registerClass(Class<? extends T> declaring, int bindingPriority) {
        OnDemandInterceptorFactory factory = new OnDemandInterceptorFactory(declaring);
        if (bindingPriority > Integer.MIN_VALUE) {
            factory.setOrder(bindingPriority);
        }
        this.register(factory);
    }

    public void registerSingleton(T interceptor) {
        this.register(new SingletonInterceptorFactory(interceptor.getClass(), interceptor));
    }

    public void registerSingleton(T interceptor, int bindingPriority) {
        SingletonInterceptorFactory factory = new SingletonInterceptorFactory(interceptor.getClass(), interceptor);
        if (bindingPriority > Integer.MIN_VALUE) {
            factory.setOrder(bindingPriority);
        }
        this.register(factory);
    }

    public class PrecedenceComparator
    implements Comparator<Match> {
        @Override
        public int compare(Match match, Match match2) {
            return match.order - match2.order;
        }
    }

    protected class LegacyPerMethodInterceptorFactory
    extends AbstractLegacyInterceptorFactory {
        public LegacyPerMethodInterceptorFactory(Class declaring, LegacyPrecedence precedence) {
            super(declaring, precedence);
            this.setPrecedence(declaring);
        }

        @Override
        protected void initialize() {
        }

        @Override
        protected Object getInterceptor() {
            Object interceptor = this.createInterceptor();
            JaxrsInterceptorRegistry.this.providerFactory.injectProperties(interceptor);
            return interceptor;
        }
    }

    protected class LegacySingletonInterceptorFactory
    extends AbstractLegacyInterceptorFactory {
        protected Object interceptor;

        public LegacySingletonInterceptorFactory(Class declaring, Object interceptor, LegacyPrecedence precedence) {
            super(declaring, precedence);
            this.interceptor = interceptor;
            this.setPrecedence(declaring);
        }

        @Override
        protected void initialize() {
            JaxrsInterceptorRegistry.this.providerFactory.injectProperties(this.interceptor);
        }

        @Override
        protected Object getInterceptor() {
            this.checkInitialize();
            return this.interceptor;
        }
    }

    public abstract class AbstractLegacyInterceptorFactory
    extends AbstractInterceptorFactory {
        protected LegacyPrecedence precedence;

        protected AbstractLegacyInterceptorFactory(Class declaring, LegacyPrecedence precedence) {
            super(declaring);
            this.precedence = precedence;
        }

        @Override
        protected void setPrecedence(Class<?> declaring) {
            this.order = this.precedence.calculateOrder(declaring);
        }

        @Override
        public Match preMatch() {
            return null;
        }

        public Object getLegacyMatch(Class declaring, AccessibleObject target) {
            Object interceptor = this.getInterceptor();
            if (interceptor instanceof AcceptedByMethod) {
                if (target == null || !(target instanceof Method)) {
                    return null;
                }
                Method method = (Method)target;
                if (((AcceptedByMethod)interceptor).accept(declaring, method)) {
                    return interceptor;
                }
                return null;
            }
            return interceptor;
        }
    }

    protected class SingletonInterceptorFactory
    extends AbstractInterceptorFactory {
        protected Object interceptor;

        public SingletonInterceptorFactory(Class declaring, Object interceptor) {
            super(declaring);
            this.interceptor = interceptor;
            this.setPrecedence(declaring);
        }

        @Override
        protected void initialize() {
            JaxrsInterceptorRegistry.this.providerFactory.injectProperties(this.interceptor);
        }

        @Override
        protected Object getInterceptor() {
            this.checkInitialize();
            return this.interceptor;
        }
    }

    protected class OnDemandInterceptorFactory
    extends AbstractInterceptorFactory {
        protected volatile Object interceptor;

        public OnDemandInterceptorFactory(Class declaring) {
            super(declaring);
            this.setPrecedence(declaring);
        }

        @Override
        protected void initialize() {
            this.interceptor = this.createInterceptor();
            JaxrsInterceptorRegistry.this.providerFactory.injectProperties(this.interceptor);
            this.initialized = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkInitialize() {
            Object tmp = this.interceptor;
            if (tmp == null) {
                OnDemandInterceptorFactory onDemandInterceptorFactory = this;
                synchronized (onDemandInterceptorFactory) {
                    tmp = this.interceptor;
                    if (tmp == null) {
                        this.initialize();
                        tmp = this.interceptor;
                    }
                }
            }
        }

        @Override
        protected Object getInterceptor() {
            this.checkInitialize();
            return this.interceptor;
        }
    }

    public abstract class AbstractInterceptorFactory
    implements InterceptorFactory {
        protected final Class declaring;
        protected int order = 7000;
        protected List<Class<? extends Annotation>> nameBound;
        protected volatile boolean initialized;

        public AbstractInterceptorFactory(Class declaring) {
            this.declaring = declaring;
        }

        protected void setPrecedence(Class<?> declaring) {
            this.nameBound = JaxrsInterceptorRegistry.getNameBound(declaring);
            this.order = JaxrsInterceptorRegistry.getBindingPriority(declaring);
        }

        protected abstract void initialize();

        protected abstract Object getInterceptor();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkInitialize() {
            boolean isInitialized = this.initialized;
            if (!isInitialized) {
                AbstractInterceptorFactory abstractInterceptorFactory = this;
                synchronized (abstractInterceptorFactory) {
                    isInitialized = this.initialized;
                    if (isInitialized) {
                        return;
                    }
                    this.initialized = true;
                    isInitialized = true;
                    this.initialize();
                }
            }
        }

        public void setOrder(int order) {
            this.order = order;
        }

        @Override
        public Match preMatch() {
            if (this.declaring.isAnnotationPresent(PreMatching.class)) {
                return new Match(this.getInterceptor(), this.order);
            }
            return null;
        }

        @Override
        public Match postMatch(Class targetClass, AccessibleObject target) {
            if (this.declaring.isAnnotationPresent(PreMatching.class)) {
                return null;
            }
            if (targetClass != null && target != null) {
                if (this.nameBound.size() > 0) {
                    for (Class<? extends Annotation> annotation : this.nameBound) {
                        if (!targetClass.isAnnotationPresent(annotation) && !target.isAnnotationPresent(annotation)) continue;
                        Object intercept = this.getInterceptor();
                        if (intercept == null) {
                            throw new NullPointerException("interceptor null from class: " + this.getClass().getName());
                        }
                        return new Match(intercept, this.order);
                    }
                    return null;
                }
                Object intercept = this.getInterceptor();
                if (intercept == null) {
                    throw new NullPointerException("interceptor null from class: " + this.getClass().getName());
                }
                return new Match(intercept, this.order);
            }
            if (this.nameBound.size() == 0) {
                Object intercept = this.getInterceptor();
                if (intercept == null) {
                    throw new NullPointerException("interceptor null from class: " + this.getClass().getName());
                }
                return new Match(intercept, this.order);
            }
            return null;
        }

        protected Object createInterceptor() {
            return JaxrsInterceptorRegistry.this.providerFactory.injectedInstance(this.declaring);
        }
    }

    public static interface InterceptorFactory {
        public Match preMatch();

        public Match postMatch(Class var1, AccessibleObject var2);
    }

    public static class Match {
        public final Object interceptor;
        public final int order;

        public Match(Object interceptor, int order) {
            this.interceptor = interceptor;
            this.order = order;
        }
    }
}

