/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.NoMessageBodyWriterFoundFailure;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.interception.ContainerResponseContextImpl;
import org.jboss.resteasy.core.interception.ResponseContainerRequestContext;
import org.jboss.resteasy.core.interception.ServerWriterInterceptorContext;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.WriterException;
import org.jboss.resteasy.util.CommitHeaderOutputStream;

public class ServerResponseWriter {
    public static void writeResponse(final BuiltResponse jaxrsResponse, HttpRequest request, final HttpResponse response, ResteasyProviderFactory providerFactory) throws WriterException {
        MediaType contentType;
        MessageBodyWriter writer;
        ResourceMethod method = (ResourceMethod)request.getAttribute(ResourceMethod.class.getName());
        ContainerResponseFilter[] responseFilters = null;
        responseFilters = method != null ? method.getResponseFilters() : (ContainerResponseFilter[])providerFactory.getContainerResponseFilterRegistry().postMatch(null, null);
        if (responseFilters != null) {
            ResponseContainerRequestContext requestContext = new ResponseContainerRequestContext(request);
            ContainerResponseContextImpl responseContext = new ContainerResponseContextImpl(request, response, jaxrsResponse);
            for (ContainerResponseFilter filter : responseFilters) {
                try {
                    filter.filter((ContainerRequestContext)requestContext, (ContainerResponseContext)responseContext);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (jaxrsResponse.getEntity() == null) {
            response.setStatus(jaxrsResponse.getStatus());
            ServerResponseWriter.commitHeaders(jaxrsResponse, response);
            return;
        }
        Type generic = jaxrsResponse.getGenericType();
        if (generic == null && method != null) {
            generic = method.getGenericReturnType();
        }
        Class type = jaxrsResponse.getEntityClass();
        Object ent = jaxrsResponse.getEntity();
        Annotation[] annotations = jaxrsResponse.getAnnotations();
        if (annotations == null && method != null) {
            annotations = method.getMethodAnnotations();
        }
        if ((writer = providerFactory.getMessageBodyWriter(type, generic, annotations, contentType = ServerResponseWriter.resolveContentType(jaxrsResponse))) == null) {
            throw new NoMessageBodyWriterFoundFailure(type, contentType);
        }
        try {
            response.setStatus(jaxrsResponse.getStatus());
            CommitHeaderOutputStream.CommitCallback callback = new CommitHeaderOutputStream.CommitCallback(){
                private boolean committed;

                @Override
                public void commit() {
                    if (this.committed) {
                        return;
                    }
                    this.committed = true;
                    ServerResponseWriter.commitHeaders(jaxrsResponse, response);
                }
            };
            CommitHeaderOutputStream os = new CommitHeaderOutputStream(response.getOutputStream(), callback);
            long size = writer.getSize(ent, type, generic, annotations, contentType);
            if (size > -1L) {
                jaxrsResponse.getMetadata().putSingle((Object)"Content-Length", (Object)String.valueOf(size));
            }
            WriterInterceptor[] writerInterceptors = null;
            writerInterceptors = method != null ? method.getWriterInterceptors() : (WriterInterceptor[])providerFactory.getServerWriterInterceptorRegistry().postMatch(null, null);
            if (writerInterceptors == null || writerInterceptors.length == 0) {
                writer.writeTo(ent, type, generic, annotations, contentType, jaxrsResponse.getMetadata(), (OutputStream)os);
            } else {
                ServerWriterInterceptorContext writerContext = new ServerWriterInterceptorContext(writerInterceptors, writer, ent, type, generic, annotations, contentType, jaxrsResponse.getMetadata(), os, request);
                writerContext.proceed();
            }
            callback.commit();
        }
        catch (Exception ex) {
            if (ex instanceof WriterException) {
                throw (WriterException)ex;
            }
            throw new WriterException(ex);
        }
    }

    public static MediaType resolveContentType(BuiltResponse response) {
        MediaType responseContentType = null;
        Object type = response.getMetadata().getFirst((Object)"Content-Type");
        if (type == null) {
            return MediaType.WILDCARD_TYPE;
        }
        responseContentType = type instanceof MediaType ? (MediaType)type : MediaType.valueOf((String)type.toString());
        return responseContentType;
    }

    public static void commitHeaders(BuiltResponse jaxrsResponse, HttpResponse response) {
        List cookies;
        if (jaxrsResponse.getMetadata() != null && (cookies = (List)jaxrsResponse.getMetadata().get((Object)"Set-Cookie")) != null) {
            Iterator it = cookies.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof NewCookie)) continue;
                NewCookie cookie = (NewCookie)next;
                response.addNewCookie(cookie);
                it.remove();
            }
            if (cookies.size() < 1) {
                jaxrsResponse.getMetadata().remove((Object)"Set-Cookie");
            }
        }
        if (jaxrsResponse.getMetadata() != null && jaxrsResponse.getMetadata().size() > 0) {
            response.getOutputHeaders().putAll(jaxrsResponse.getMetadata());
        }
    }
}

