/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.StateType;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore;
import com.arjuna.ats.internal.arjuna.objectstore.LogInstance;
import com.arjuna.ats.internal.arjuna.objectstore.LogPurger;
import com.arjuna.ats.internal.arjuna.objectstore.PurgeShutdownHook;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class LogStore
extends FileSystemStore {
    public static final long LOG_SIZE = 0xA00000L;
    private static final String FILE_MODE = "rwd";
    private static Object _lock = new Object();
    private static ArrayList<LogInstance> _logNames = new ArrayList();
    private final long _maxFileSize;
    private final long _purgeTime;
    private final LogPurger _purger;
    private final boolean _synchronousRemoval;
    private static final byte[] _redzone = new byte[]{2, 4, 6, 8};
    private static final byte[] _removedState = new byte[]{13, 14, 10, 13, 11, 14, 14, 15};
    private static final char HIDDENCHAR = '~';

    @Override
    public int currentState(Uid objUid, String tName) throws ObjectStoreException {
        InputObjectState ios = new InputObjectState();
        if (this.allObjUids(tName, ios, -1)) {
            Uid tempUid = new Uid(Uid.nullUid());
            do {
                try {
                    tempUid = UidHelper.unpackFrom(ios);
                }
                catch (Exception ex) {
                    tsLogger.i18NLogger.warn_LogStore_1(ex);
                    return -1;
                }
                if (!tempUid.equals(objUid)) continue;
                return 1;
            } while (tempUid.notEquals(Uid.nullUid()));
            return -1;
        }
        return -1;
    }

    @Override
    public boolean commit_state(Uid objUid, String tName) throws ObjectStoreException {
        return true;
    }

    @Override
    public boolean hide_state(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LogStore.hide_state(" + String.valueOf(u) + ", " + tn + ")"));
        }
        return false;
    }

    @Override
    public boolean reveal_state(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LogStore.reveal_state(" + String.valueOf(u) + ", " + tn + ")"));
        }
        return false;
    }

    @Override
    public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LogStore.read_uncommitted(" + String.valueOf(u) + ", " + tn + ")"));
        }
        return null;
    }

    @Override
    public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LogStore.remove_uncommitted(" + String.valueOf(u) + ", " + tn + ")"));
        }
        return false;
    }

    @Override
    public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LogStore.write_committed(" + String.valueOf(storeUid) + ", " + tName + ")"));
        }
        try {
            return super.write_committed(storeUid, tName, state);
        }
        catch (ObjectStoreException ex) {
            this.removeFromLog(storeUid);
            throw ex;
        }
    }

    @Override
    public boolean write_uncommitted(Uid u, String tn, OutputObjectState s) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LogStore.write_uncommitted(" + String.valueOf(u) + ", " + tn + ", " + String.valueOf(s) + ")"));
        }
        return false;
    }

    public boolean allLogUids(String tName, InputObjectState state, int match) throws ObjectStoreException {
        return super.allObjUids(tName, state, match);
    }

    @Override
    public boolean allObjUids(String tName, InputObjectState state, int match) throws ObjectStoreException {
        this._purger.trigger();
        InputObjectState logs = new InputObjectState();
        OutputObjectState objUids = new OutputObjectState();
        if (!super.allObjUids(tName, logs, match)) {
            return false;
        }
        Uid logName = new Uid(Uid.nullUid());
        try {
            do {
                ArrayList<InputObjectState> txs;
                if (!(logName = UidHelper.unpackFrom(logs)).notEquals(Uid.nullUid()) || (txs = this.scanLog(logName, tName)).isEmpty()) continue;
                for (int i = 0; i < txs.size(); ++i) {
                    UidHelper.packInto(txs.get(i).stateUid(), objUids);
                }
            } while (logName.notEquals(Uid.nullUid()));
            UidHelper.packInto(Uid.nullUid(), objUids);
            state.setBuffer(objUids.buffer());
        }
        catch (IOException ex) {
            tsLogger.i18NLogger.warn_LogStore_1(ex);
            return false;
        }
        return true;
    }

    public LogStore(ObjectStoreEnvironmentBean objectStoreEnvironmentBean) throws ObjectStoreException {
        super(objectStoreEnvironmentBean);
        this.doSync = objectStoreEnvironmentBean.isTransactionSync();
        this._synchronousRemoval = objectStoreEnvironmentBean.isSynchronousRemoval();
        this._purgeTime = objectStoreEnvironmentBean.getPurgeTime();
        this._maxFileSize = objectStoreEnvironmentBean.getTxLogSize();
        this._purger = new LogPurger(this, this._purgeTime);
        this._purger.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(new PurgeShutdownHook(this._purger));
        this._purger.start();
    }

    protected boolean unlockAndClose(File fd, RandomAccessFile rf) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("RandomAccessFile.unlockAndClose(" + String.valueOf(fd) + ", " + String.valueOf(rf) + ")"));
        }
        boolean closedOk = this.unlock(fd);
        try {
            rf.close();
        }
        catch (Exception e) {
            closedOk = false;
        }
        return closedOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean write_state(Uid objUid, String tName, OutputObjectState state, int ft) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ShadowingStore.write_state(" + String.valueOf(objUid) + ", " + tName + ", " + StateType.stateTypeString(ft) + ")"));
        }
        String fname = null;
        File fd = null;
        if (tName != null) {
            int imageSize = state.length();
            byte[] uidString = objUid.stringForm().getBytes(StandardCharsets.UTF_8);
            int buffSize = _redzone.length + uidString.length + imageSize + 8;
            RandomAccessFile ofile = null;
            FileLock lock = null;
            if (imageSize > 0) {
                LogInstance.TransactionData theLogEntry = this.getLogName(objUid, tName, buffSize);
                LogInstance theLog = theLogEntry.container;
                if (theLog == null) {
                    throw new ObjectStoreException();
                }
                fname = this.genPathName(theLog.getName(), tName, ft);
                fd = this.openAndLock(fname, 1, true);
                if (fd == null) {
                    tsLogger.i18NLogger.warn_objectstore_ShadowingStore_18(fname);
                    return false;
                }
                boolean setLength = !fd.exists();
                try {
                    ofile = new RandomAccessFile(fd, FILE_MODE);
                    if (setLength) {
                        ofile.setLength(this._maxFileSize);
                    } else if (theLog.remaining() < (long)buffSize) {
                        long size = ofile.length() + (long)buffSize - theLog.remaining();
                        ofile.setLength(size);
                        theLog.resize(size);
                    }
                    ByteBuffer buff = ByteBuffer.allocate(buffSize);
                    buff.put(_redzone);
                    buff.putInt(uidString.length);
                    buff.put(uidString);
                    buff.putInt(imageSize);
                    buff.put(state.buffer());
                    Object object = _lock;
                    synchronized (object) {
                        ofile.seek(theLogEntry.offset);
                        ofile.write(buff.array());
                    }
                }
                catch (SyncFailedException e) {
                    this.unlockAndClose(fd, ofile);
                    throw new ObjectStoreException("ShadowingStore::write_state() - write failed to sync for " + fname, e);
                }
                catch (FileNotFoundException e) {
                    this.unlockAndClose(fd, ofile);
                    if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                        tsLogger.i18NLogger.warn_LogStore_1(e);
                    }
                    throw new ObjectStoreException("ShadowingStore::write_state() - write failed to locate file " + fname + ": " + String.valueOf(e), e);
                }
                catch (IOException e) {
                    this.unlockAndClose(fd, ofile);
                    if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                        tsLogger.i18NLogger.warn_LogStore_1(e);
                    }
                    throw new ObjectStoreException("ShadowingStore::write_state() - write failed for " + fname + ": " + String.valueOf(e), e);
                }
                finally {
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                    catch (IOException ex) {
                        tsLogger.i18NLogger.warn_LogStore_1(ex);
                    }
                }
            }
            if (!this.unlockAndClose(fd, ofile)) {
                tsLogger.i18NLogger.warn_objectstore_ShadowingStore_19(fname);
            }
            super.addToCache(fname);
            return true;
        }
        throw new ObjectStoreException("ShadowStore::write_state - " + tsLogger.i18NLogger.get_objectstore_notypenameuid() + String.valueOf(objUid));
    }

    @Override
    protected InputObjectState read_state(Uid u, String tn, int s) throws ObjectStoreException {
        this._purger.trigger();
        LogInstance.TransactionData td = this.getLogName(u, tn, -1L);
        if (td == null) {
            throw new ObjectStoreException();
        }
        ArrayList<InputObjectState> states = this.scanLog(td.container.getName(), tn);
        if (states == null || states.isEmpty()) {
            return null;
        }
        for (int i = 0; i < states.size(); ++i) {
            if (!states.get(i).stateUid().equals(u)) continue;
            return states.get(i);
        }
        return null;
    }

    @Override
    protected boolean remove_state(Uid u, String tn, int s) throws ObjectStoreException {
        try {
            if (this._synchronousRemoval) {
                OutputObjectState removalState = new OutputObjectState(u, tn);
                removalState.packBytes(_removedState);
                if (!this.write_state(u, tn, removalState, s)) {
                    throw new ObjectStoreException();
                }
            } else {
                this._purger.addRemovedState(u, tn, s);
            }
        }
        catch (IOException ex) {
            throw new ObjectStoreException(ex.toString(), ex);
        }
        catch (Throwable ex) {
            if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                tsLogger.i18NLogger.warn_LogStore_1(ex);
            }
            throw new ObjectStoreException(ex.toString(), ex);
        }
        finally {
            this.removeFromLog(u);
        }
        return true;
    }

    @Override
    protected boolean lock(File fd, int lmode, boolean create) {
        return true;
    }

    @Override
    protected boolean unlock(File fd) {
        return true;
    }

    @Override
    protected String genPathName(Uid objUid, String tName, int ft) throws ObjectStoreException {
        Object fname = super.genPathName(objUid, tName, ft);
        if (ft == 2) {
            fname = (String)fname + "~";
        }
        return fname;
    }

    boolean removeState(Uid u, String tn, int s) throws ObjectStoreException {
        try {
            OutputObjectState removalState = new OutputObjectState(u, tn);
            removalState.packBytes(_removedState);
            if (!this.write_state(u, tn, removalState, s)) {
                throw new ObjectStoreException();
            }
        }
        catch (IOException ex) {
            throw new ObjectStoreException(ex.toString(), ex);
        }
        return true;
    }

    boolean truncateLogs() throws ObjectStoreException {
        return this.truncateLogs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean truncateLogs(boolean force) throws ObjectStoreException {
        ArrayList<LogInstance> arrayList = _logNames;
        synchronized (arrayList) {
            Iterator<LogInstance> iter = _logNames.iterator();
            while (iter.hasNext()) {
                boolean delete = false;
                LogInstance log = null;
                try {
                    log = iter.next();
                    if (log.isFrozen() || force) {
                        delete = this.truncateLog(log, force);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!delete) continue;
                iter.remove();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean truncateLog(LogInstance log, boolean force) throws ObjectStoreException {
        boolean delete = false;
        Object object = _lock;
        synchronized (object) {
            block20: {
                File fd = new File(this.genPathName(log.getName(), log.getTypeName(), 1));
                try {
                    ArrayList<InputObjectState> objectStates = this.scanLog(log.getName(), log.getTypeName());
                    if (objectStates != null && !objectStates.isEmpty()) {
                        String fname = this.genPathName(log.getName(), log.getTypeName(), 2);
                        File fd2 = this.openAndLock(fname, 1, true);
                        RandomAccessFile oFile = new RandomAccessFile(fd2, FILE_MODE);
                        int size = 0;
                        oFile.setLength(this._maxFileSize);
                        for (int i = 0; i < objectStates.size(); ++i) {
                            byte[] uidString = objectStates.get(i).stateUid().stringForm().getBytes(StandardCharsets.UTF_8);
                            int buffSize = _redzone.length + uidString.length + objectStates.get(i).buffer().length + 8;
                            ByteBuffer buff = ByteBuffer.allocate(buffSize);
                            size += buffSize;
                            try {
                                buff.put(_redzone);
                                buff.putInt(uidString.length);
                                buff.put(uidString);
                                buff.putInt(objectStates.get(i).buffer().length);
                                buff.put(objectStates.get(i).buffer(), 0, objectStates.get(i).buffer().length);
                                continue;
                            }
                            catch (Exception ex) {
                                if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                                    tsLogger.i18NLogger.warn_LogStore_1(ex);
                                }
                                fd2.delete();
                                this.unlockAndClose(fd2, oFile);
                                throw new ObjectStoreException(ex.toString(), ex);
                            }
                        }
                        try {
                            if (force) {
                                oFile.setLength(size);
                                log.freeze();
                            }
                            fd2.renameTo(fd);
                            break block20;
                        }
                        catch (Exception ex) {
                            if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                                tsLogger.i18NLogger.warn_LogStore_1(ex);
                            }
                            throw new ObjectStoreException(ex.toString(), ex);
                        }
                        finally {
                            this.unlockAndClose(fd2, oFile);
                        }
                    }
                    fd.delete();
                    delete = true;
                }
                catch (ObjectStoreException ex) {
                    if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                        tsLogger.i18NLogger.warn_LogStore_1(ex);
                    }
                    throw ex;
                }
                catch (Exception ex) {
                    if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                        tsLogger.i18NLogger.warn_LogStore_1(ex);
                    }
                    throw new ObjectStoreException(ex.toString(), ex);
                }
            }
        }
        return delete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ArrayList<InputObjectState> scanLog(Uid logName, String typeName) throws ObjectStoreException {
        Object object = _lock;
        synchronized (object) {
            try {
                String fname = this.genPathName(logName, typeName, 1);
                File fd = this.openAndLock(fname, 1, true);
                RandomAccessFile iFile = new RandomAccessFile(fd, FILE_MODE);
                try {
                    ArrayList<InputObjectState> objectStates = new ArrayList<InputObjectState>();
                    iFile.seek(0L);
                    while (iFile.getFilePointer() < iFile.length()) {
                        byte[] buff = new byte[_redzone.length];
                        iFile.read(buff);
                        if (!this.redzoneProtected(buff)) break;
                        int uidSize = iFile.readInt();
                        byte[] uidString = new byte[uidSize];
                        iFile.read(uidString);
                        Uid txId = new Uid(new String(uidString, StandardCharsets.UTF_8));
                        int imageSize = iFile.readInt();
                        byte[] imageState = new byte[imageSize];
                        iFile.read(imageState);
                        try {
                            InputObjectState state = new InputObjectState(txId, "", imageState);
                            objectStates.add(state);
                        }
                        catch (Exception ex) {
                            if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                                tsLogger.i18NLogger.warn_LogStore_1(ex);
                            }
                            throw new ObjectStoreException(ex.toString(), ex);
                        }
                    }
                    this.unlockAndClose(fd, iFile);
                    iFile = null;
                    ArrayList<InputObjectState> deletedLogs = new ArrayList<InputObjectState>();
                    for (int i = 0; i < objectStates.size(); ++i) {
                        InputObjectState curr = (InputObjectState)objectStates.get(i);
                        try {
                            if (Arrays.equals(curr.unpackBytes(), _removedState)) {
                                deletedLogs.add(curr);
                                continue;
                            }
                            curr.reread();
                            continue;
                        }
                        catch (Exception ex) {
                            curr.reread();
                        }
                    }
                    if (!deletedLogs.isEmpty()) {
                        objectStates.removeAll(deletedLogs);
                        this.deleteEntries(objectStates, deletedLogs);
                        this.pruneEntries(objectStates);
                        ArrayList<InputObjectState> arrayList2 = objectStates;
                        return arrayList2;
                    }
                    ArrayList<InputObjectState> arrayList = objectStates;
                    return arrayList;
                }
                finally {
                    if (iFile != null) {
                        this.unlockAndClose(fd, iFile);
                    }
                }
            }
            catch (ObjectStoreException ex) {
                if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                    tsLogger.i18NLogger.warn_LogStore_1(ex);
                }
                throw ex;
            }
            catch (Exception ex) {
                if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                    tsLogger.i18NLogger.warn_LogStore_1(ex);
                }
                throw new ObjectStoreException(ex.toString(), ex);
            }
        }
    }

    private final boolean redzoneProtected(byte[] buff) {
        for (int i = 0; i < _redzone.length; ++i) {
            if (buff[i] == _redzone[i]) continue;
            return false;
        }
        return true;
    }

    private final void deleteEntries(ArrayList<InputObjectState> allStates, ArrayList<InputObjectState> deletedStates) {
        for (int i = 0; i < deletedStates.size(); ++i) {
            Uid txId = deletedStates.get(i).stateUid();
            for (int j = 0; j < allStates.size(); ++j) {
                if (!allStates.get(j).stateUid().equals(txId)) continue;
                allStates.remove(j);
            }
        }
        deletedStates.clear();
    }

    private final void pruneEntries(ArrayList<InputObjectState> allStates) {
        for (int j = allStates.size() - 1; j >= 0; --j) {
            Uid txId = allStates.get(j).stateUid();
            for (int i = 0; i < j; ++i) {
                if (!allStates.get(i).stateUid().equals(txId)) continue;
                allStates.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LogInstance.TransactionData getLogName(Uid txid, String tName, long size) throws ObjectStoreException {
        ArrayList<LogInstance> arrayList = _logNames;
        synchronized (arrayList) {
            Iterator<LogInstance> iter = _logNames.iterator();
            LogInstance entry2 = null;
            while (iter.hasNext()) {
                entry2 = iter.next();
                if (!entry2.present(txid)) continue;
                if (size == -1L) {
                    return entry2.getTxId(txid);
                }
                return entry2.addTxId(txid, size);
            }
            for (LogInstance entry2 : _logNames) {
                if (entry2.isFrozen()) continue;
                if (entry2.remaining() > size) {
                    return entry2.addTxId(txid, size);
                }
                entry2.freeze();
            }
            entry2 = new LogInstance(tName, this._maxFileSize);
            _logNames.add(entry2);
            return entry2.addTxId(txid, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeFromLog(Uid txid) {
        if (this._synchronousRemoval) {
            ArrayList<LogInstance> arrayList = _logNames;
            synchronized (arrayList) {
                Iterator<LogInstance> iter = _logNames.iterator();
                LogInstance entry = null;
                while (iter.hasNext() && !(entry = iter.next()).present(txid)) {
                }
            }
        }
    }
}

