/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.w3c.dom.Document;

@Component(role=QSChecker.class, hint="moduleDefinedChecker")
public class ModuleDefinedChecker
extends AbstractBaseCheckerAdapter {
    @Override
    public String getCheckerDescription() {
        return "Checks if all project subdirectories are defined as module";
    }

    private boolean isProjectSubdir(File f) {
        return Arrays.asList(f.list()).contains("pom.xml");
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        File rootDir = project.getBasedir();
        ArrayList<String> submodules = new ArrayList<String>();
        for (File f : rootDir.listFiles()) {
            if (!f.isDirectory() || !this.isProjectSubdir(f)) continue;
            submodules.add(f.getName());
        }
        submodules.removeAll(this.getConfigurationProvider().getQuickstartsRules(project.getGroupId()).getIgnoredModules());
        for (String dir : submodules) {
            boolean contains = project.getModules().contains(dir);
            if (!contains) {
                Profile profile;
                Iterator i$ = project.getModel().getProfiles().iterator();
                while (i$.hasNext() && !(contains = (profile = (Profile)i$.next()).getModules().contains(dir))) {
                }
            }
            if (contains) continue;
            String msg = "The following dir [%s] is not listed as one of project submodules";
            this.addViolation(project.getFile(), results, 0, String.format(msg, dir));
        }
    }
}

