/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployment.AnnotationMetaDataDeployer;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ejb.jboss.JBoss50MetaData;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.IdMetaDataImpl;

public class MergedJBossMetaDataDeployer
extends AbstractDeployer {
    public static final String EJB_MERGED_ATTACHMENT_NAME = "merged." + JBossMetaData.class.getName();

    public MergedJBossMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(EjbJarMetaData.class);
        this.addInput(JBossMetaData.class);
        this.addInput(AnnotationMetaDataDeployer.EJB_ANNOTATED_ATTACHMENT_NAME);
        this.setOutput(JBossMetaData.class);
        this.addOutput(EJB_MERGED_ATTACHMENT_NAME);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)unit.getAttachment(EjbJarMetaData.class);
        JBossMetaData metaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        String key = AnnotationMetaDataDeployer.EJB_ANNOTATED_ATTACHMENT_NAME;
        JBossMetaData annotatedMetaData = (JBossMetaData)unit.getAttachment(key, JBossMetaData.class);
        if (ejbJarMetaData == null && metaData == null && annotatedMetaData == null) {
            return;
        }
        JBoss50MetaData specMetaData = new JBoss50MetaData();
        if (ejbJarMetaData != null) {
            specMetaData.merge(null, ejbJarMetaData);
            if (annotatedMetaData != null) {
                JBoss50MetaData specMerged = new JBoss50MetaData();
                specMerged.merge((JBossMetaData)specMetaData, annotatedMetaData);
                specMetaData = specMerged;
            }
        } else {
            specMetaData = annotatedMetaData;
        }
        JBossMetaData mergedMetaData = new JBossMetaData();
        mergedMetaData.merge(metaData, (JBossMetaData)specMetaData);
        DeploymentUnit topUnit = unit.getTopLevel();
        if (topUnit != null && topUnit.getAttachment(JBossAppMetaData.class) != null) {
            SecurityRolesMetaData earSecurityRolesMetaData;
            JBossAppMetaData earMetaData = (JBossAppMetaData)topUnit.getAttachment(JBossAppMetaData.class);
            String securityDomain = earMetaData.getSecurityDomain();
            if (securityDomain != null && mergedMetaData.getSecurityDomain() == null) {
                mergedMetaData.setSecurityDomain(securityDomain);
            }
            if ((earSecurityRolesMetaData = earMetaData.getSecurityRoles()) != null) {
                SecurityRolesMetaData mergedSecurityRolesMetaData;
                JBossAssemblyDescriptorMetaData jadmd = mergedMetaData.getAssemblyDescriptor();
                if (jadmd == null) {
                    jadmd = new JBossAssemblyDescriptorMetaData();
                    mergedMetaData.setAssemblyDescriptor(jadmd);
                }
                if ((mergedSecurityRolesMetaData = jadmd.getSecurityRoles()) == null) {
                    jadmd.setSecurityRoles(earSecurityRolesMetaData);
                }
                if (mergedSecurityRolesMetaData != null) {
                    mergedSecurityRolesMetaData.merge((IdMetaDataImpl)mergedSecurityRolesMetaData, (IdMetaDataImpl)earSecurityRolesMetaData);
                }
            }
        }
        unit.getTransientManagedObjects().addAttachment(JBossMetaData.class, (Object)mergedMetaData);
        unit.addAttachment(EJB_MERGED_ATTACHMENT_NAME, (Object)mergedMetaData, JBossMetaData.class);
    }
}

