/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.UnknownHostException;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.services.net.BindingAddHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

abstract class AbstractBindingWriteHandler
extends AbstractWriteAttributeHandler<RollbackInfo> {
    private static final ServiceName SOCKET_BINDING = SocketBinding.JBOSS_BINDING_NAME;

    public AbstractBindingWriteHandler(AttributeDefinition ... definitions) {
        super(definitions);
    }

    abstract void handleRuntimeChange(ModelNode var1, String var2, ModelNode var3, SocketBinding var4) throws OperationFailedException;

    abstract void handleRuntimeRollback(ModelNode var1, String var2, ModelNode var3, SocketBinding var4);

    protected boolean requiresRestart() {
        return false;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<RollbackInfo> handbackHolder) throws OperationFailedException {
        boolean bound;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathElement element = address.getLastElement();
        String bindingName = element.getValue();
        ModelNode bindingModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        ServiceController controller = context.getServiceRegistry(true).getRequiredService(SOCKET_BINDING.append(new String[]{bindingName}));
        SocketBinding binding = controller.getState() == ServiceController.State.UP ? (SocketBinding)SocketBinding.class.cast(controller.getValue()) : null;
        boolean bl = bound = binding != null && binding.isBound();
        if (binding == null) {
            this.handleBindingReinstall(context, bindingName, bindingModel);
        } else {
            if (bound) {
                return true;
            }
            this.handleRuntimeChange(operation, attributeName, resolvedValue, binding);
        }
        handbackHolder.setHandback((Object)new RollbackInfo(bindingName, bindingModel, binding));
        return this.requiresRestart();
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, RollbackInfo handback) throws OperationFailedException {
        if (handback != null) {
            if (handback.revertBinding()) {
                this.revertBindingReinstall(context, handback.bindingName, handback.bindingModel, attributeName, valueToRevert);
            } else {
                this.handleRuntimeRollback(operation, attributeName, valueToRevert, handback.binding);
            }
        }
    }

    private void handleBindingReinstall(OperationContext context, String bindingName, ModelNode bindingModel) throws OperationFailedException {
        context.removeService(SOCKET_BINDING.append(new String[]{bindingName}));
        try {
            BindingAddHandler.installBindingService(context, bindingModel, bindingName);
        }
        catch (UnknownHostException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
    }

    private void revertBindingReinstall(OperationContext context, String bindingName, ModelNode bindingModel, String attributeName, ModelNode previousValue) {
        context.removeService(SOCKET_BINDING.append(new String[]{bindingName}));
        ModelNode unresolvedConfig = bindingModel.clone();
        unresolvedConfig.get(attributeName).set(previousValue);
        try {
            BindingAddHandler.installBindingService(context, unresolvedConfig, bindingName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class RollbackInfo {
        private final String bindingName;
        private final ModelNode bindingModel;
        private final SocketBinding binding;

        RollbackInfo(String bindingName, ModelNode bindingModel, SocketBinding binding) {
            this.bindingName = bindingName;
            this.bindingModel = bindingModel;
            this.binding = binding;
        }

        boolean revertBinding() {
            return this.binding == null;
        }
    }
}

