/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class EnumValidator<E extends Enum<E>>
extends ModelTypeValidator
implements AllowedValuesValidator {
    private final EnumSet<E> allowedValues;
    private final Class<E> enumType;

    public EnumValidator(Class<E> enumType, boolean nullable, E ... allowed) {
        this(enumType, nullable, false, (Enum[])allowed);
    }

    public EnumValidator(Class<E> enumType, boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions);
        this.enumType = enumType;
        this.allowedValues = EnumSet.allOf(enumType);
    }

    public EnumValidator(Class<E> enumType, boolean nullable, boolean allowExpressions, E ... allowed) {
        super(ModelType.STRING, nullable, allowExpressions);
        this.enumType = enumType;
        this.allowedValues = EnumSet.noneOf(enumType);
        for (E value : allowed) {
            this.allowedValues.add(value);
        }
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        String tuString;
        E enumValue;
        super.validateParameter(parameterName, value);
        if (value.isDefined() && ((enumValue = Enum.valueOf(this.enumType, (tuString = value.asString()).toUpperCase(Locale.ENGLISH))) == null || !this.allowedValues.contains(enumValue))) {
            throw new OperationFailedException(new ModelNode().set(String.format("Invalid value %s for %s; legal values are %s", tuString, parameterName, this.allowedValues)));
        }
    }

    @Override
    public List<ModelNode> getAllowedValues() {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        for (Enum value : this.allowedValues) {
            result.add(new ModelNode().set(value.name()));
        }
        return result;
    }
}

