/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.operations.common.ExtensionAddHandler;
import org.jboss.dmr.ModelNode;

public class ParallelExtensionAddHandler
implements OperationStepHandler {
    private final ExecutorService executor;
    private final List<ParsedBootOp> extensionAdds = new ArrayList<ParsedBootOp>();

    public ParallelExtensionAddHandler(ExecutorService executorService) {
        this.executor = executorService;
    }

    public void addParsedOp(ParsedBootOp op, ExtensionAddHandler handler) {
        this.extensionAdds.add(new ParsedBootOp(op, handler));
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(this.getParallelExtensionInitializeStep(), OperationContext.Stage.IMMEDIATE);
        for (int i = this.extensionAdds.size() - 1; i >= 0; --i) {
            ParsedBootOp op = this.extensionAdds.get(i);
            context.addStep(op.response, op.operation, op.handler, OperationContext.Stage.IMMEDIATE);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    private OperationStepHandler getParallelExtensionInitializeStep() {
        return new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                long start = System.currentTimeMillis();
                LinkedHashMap<String, Future<OperationFailedException>> futures = new LinkedHashMap<String, Future<OperationFailedException>>();
                for (ParsedBootOp parsedBootOp : ParallelExtensionAddHandler.this.extensionAdds) {
                    String module = parsedBootOp.address.getLastElement().getValue();
                    ExtensionAddHandler addHandler = (ExtensionAddHandler)ExtensionAddHandler.class.cast(parsedBootOp.handler);
                    Future<OperationFailedException> future = ParallelExtensionAddHandler.this.executor.submit(new ExtensionInitializeTask(module, addHandler));
                    futures.put(module, future);
                }
                for (Map.Entry entry : futures.entrySet()) {
                    try {
                        OperationFailedException ofe = (OperationFailedException)((Future)entry.getValue()).get();
                        if (ofe == null) continue;
                        throw ofe;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw ControllerMessages.MESSAGES.moduleInitializationInterrupted((String)entry.getKey());
                    }
                    catch (ExecutionException e) {
                        throw ControllerMessages.MESSAGES.failedInitializingModule(e, (String)entry.getKey());
                    }
                }
                if (ControllerLogger.ROOT_LOGGER.isDebugEnabled()) {
                    long elapsed = System.currentTimeMillis() - start;
                    ControllerLogger.ROOT_LOGGER.debugf("Initialized extensions in [%d] ms", elapsed);
                }
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        };
    }

    private static class ExtensionInitializeTask
    implements Callable<OperationFailedException> {
        private final String module;
        private final ExtensionAddHandler addHandler;

        public ExtensionInitializeTask(String module, ExtensionAddHandler addHandler) {
            this.module = module;
            this.addHandler = addHandler;
        }

        @Override
        public OperationFailedException call() {
            OperationFailedException failure = null;
            try {
                this.addHandler.initializeExtension(this.module);
            }
            catch (OperationFailedException e) {
                failure = e;
            }
            return failure;
        }
    }
}

