/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.jacoco.container;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.runtime.IRuntime;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandService;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.extension.jacoco.CoverageDataCommand;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;

public class ShutdownCoverageData {
    @Inject
    private Instance<IRuntime> runtimeInst;
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCoverageData(@Observes AfterSuite arqEvent) throws Exception {
        IRuntime runtime = (IRuntime)this.runtimeInst.get();
        if (runtime != null) {
            ByteArrayOutputStream coverageOutputStream = null;
            try {
                coverageOutputStream = new ByteArrayOutputStream();
                ExecutionDataWriter writer = new ExecutionDataWriter((OutputStream)coverageOutputStream);
                runtime.collect((IExecutionDataVisitor)writer, (ISessionInfoVisitor)writer, true);
            }
            finally {
                runtime.shutdown();
                if (coverageOutputStream != null) {
                    try {
                        coverageOutputStream.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not close coverage file", e);
                    }
                }
            }
            this.getCommandService().execute((Command)new CoverageDataCommand(coverageOutputStream.toByteArray()));
        }
    }

    private CommandService getCommandService() {
        ServiceLoader loader = (ServiceLoader)this.serviceLoader.get();
        if (loader == null) {
            throw new IllegalStateException("No " + ServiceLoader.class.getName() + " found in context");
        }
        CommandService service = (CommandService)loader.onlyOne(CommandService.class);
        if (service == null) {
            throw new IllegalStateException("No " + CommandService.class.getName() + " found in context");
        }
        return service;
    }
}

