/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory.remote.reusable;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.webdriver.factory.RemoteWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusableCapabilities;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.SerializationUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.SessionId;

public class ReusedSession
implements Serializable {
    private static final long serialVersionUID = -5332705183394774545L;
    private static final Logger log = Logger.getLogger(RemoteWebDriverFactory.class.getName());
    private String opaqueKey;
    private ReusableCapabilities capabilities;

    ReusedSession(SessionId sessionId, Capabilities capabilities) {
        this.opaqueKey = sessionId.toString();
        this.capabilities = ReusedSession.createReusableCapabilities(capabilities);
    }

    ReusedSession(SessionId sessionId, ReusableCapabilities capabilities) {
        this.opaqueKey = sessionId.toString();
        this.capabilities = capabilities;
    }

    public static ReusedSession createInstance(SessionId sessionId, Capabilities capabilities) {
        ReusableCapabilities reusableCapabilities = ReusedSession.createReusableCapabilities(capabilities);
        return new ReusedSession(sessionId, (Capabilities)new MutableCapabilities(reusableCapabilities.getCapabilities()));
    }

    static ReusableCapabilities createReusableCapabilities(Capabilities driverCapabilities) {
        ReusableCapabilities capabilitiesForReuse = new ReusableCapabilities();
        for (Map.Entry capability : driverCapabilities.asMap().entrySet()) {
            String key = (String)capability.getKey();
            Object value = capability.getValue();
            if (value instanceof Serializable) {
                try {
                    SerializationUtils.serializeToBytes((Serializable)value);
                    capabilitiesForReuse.setCapability((String)capability.getKey(), capability.getValue());
                }
                catch (IOException e) {
                    log.log(Level.FINE, "Capability {0} has unserializable value of type {1} and value {2}. Caused by {3}.", new Object[]{key, value != null ? value.getClass().getName() : "unknown", value, e.getCause() == null ? e : e.getCause()});
                }
                continue;
            }
            log.log(Level.FINE, "Ignoring capability {0} of type {1} and value {2}, does not implement Serializable interface", new Object[]{key, value != null ? value.getClass().getName() : "unknown", value});
        }
        return capabilitiesForReuse;
    }

    public SessionId getSessionId() {
        return new SessionId(this.opaqueKey);
    }

    public Capabilities getCapabilities() {
        return new MutableCapabilities(this.capabilities.getCapabilities());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * result + (this.opaqueKey == null ? 0 : this.opaqueKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReusedSession other = (ReusedSession)obj;
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        return !(this.opaqueKey == null ? other.opaqueKey != null : !this.opaqueKey.equals(other.opaqueKey));
    }

    public String toString() {
        return "ReusedSession [opaqueKey=" + this.opaqueKey + ", capabilities=" + this.capabilities + "]";
    }
}

