/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.spi.LoadableExtension;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneInstanceEnhancer;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.augmentation.AugmentingEnhancer;
import org.jboss.arquillian.drone.webdriver.binary.process.SeleniumServerExecutor;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.ChromeDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.EdgeDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.FirefoxDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.HtmlUnitDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.InternetExplorerDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.RemoteWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.SafariDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.WebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusableRemoteWebDriverExtension;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSessionPermanentFileStorage;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSessionPermanentStorage;
import org.jboss.arquillian.drone.webdriver.impl.BrowserCapabilitiesRegistrar;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.jboss.arquillian.drone.webdriver.window.WindowResizer;

public class DroneWebDriverExtension
implements LoadableExtension {
    private static final Logger log = Logger.getLogger(DroneWebDriverExtension.class.getName());

    public void register(LoadableExtension.ExtensionBuilder builder) {
        this.registerFactoryService(builder, ChromeDriverFactory.class, "org.openqa.selenium.chrome.ChromeDriver");
        this.registerFactoryService(builder, EdgeDriverFactory.class, "org.openqa.selenium.edge.EdgeDriver");
        this.registerFactoryService(builder, FirefoxDriverFactory.class, "org.openqa.selenium.firefox.FirefoxDriver");
        this.registerFactoryService(builder, HtmlUnitDriverFactory.class, "org.openqa.selenium.htmlunit.HtmlUnitDriver");
        this.registerFactoryService(builder, InternetExplorerDriverFactory.class, "org.openqa.selenium.ie.InternetExplorerDriver");
        this.registerFactoryService(builder, WebDriverFactory.class, "org.openqa.selenium.WebDriver");
        this.registerFactoryService(builder, RemoteWebDriverFactory.class, "org.openqa.selenium.remote.RemoteWebDriver");
        this.registerFactoryService(builder, SafariDriverFactory.class, "org.openqa.selenium.safari.SafariDriver");
        builder.observer(BrowserCapabilitiesRegistrar.class);
        builder.service(BrowserCapabilities.class, BrowserCapabilitiesList.Chrome.class);
        builder.service(BrowserCapabilities.class, BrowserCapabilitiesList.Edge.class);
        builder.service(BrowserCapabilities.class, BrowserCapabilitiesList.Firefox.class);
        builder.service(BrowserCapabilities.class, BrowserCapabilitiesList.HtmlUnit.class);
        builder.service(BrowserCapabilities.class, BrowserCapabilitiesList.InternetExplorer.class);
        builder.service(BrowserCapabilities.class, BrowserCapabilitiesList.Remote.class);
        builder.service(BrowserCapabilities.class, BrowserCapabilitiesList.Safari.class);
        builder.service(BrowserCapabilities.class, BrowserCapabilitiesList.ChromeHeadless.class);
        builder.observer(ReusableRemoteWebDriverExtension.class);
        builder.service(ReusedSessionPermanentStorage.class, ReusedSessionPermanentFileStorage.class);
        builder.service(DroneInstanceEnhancer.class, AugmentingEnhancer.class);
        builder.observer(WindowResizer.class);
        builder.observer(SeleniumServerExecutor.class);
    }

    private <T extends Configurator & Instantiator> void registerFactoryService(LoadableExtension.ExtensionBuilder builder, Class<T> factory, String expectedDriver) {
        try {
            Class.forName(expectedDriver, false, this.getClass().getClassLoader());
            builder.service(Configurator.class, factory);
            builder.service(Instantiator.class, factory);
            builder.service(Destructor.class, factory);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.WARNING, "The required web driver class {0} is not on your class path so the factory {1} will not be available.", new Object[]{expectedDriver, factory.getCanonicalName()});
        }
    }
}

