/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.api.annotation.DroneLifecycle;
import org.jboss.arquillian.drone.api.annotation.Qualifier;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static Constructor<?> getConstructor(final Class<?> clazz, final Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws NoSuchMethodException {
                    return clazz.getConstructor(argumentTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static <T> T newInstance(String className, Class<?>[] argumentTypes, Object[] arguments, Class<T> expectedType) {
        Object obj;
        if (className == null) {
            throw new IllegalArgumentException("ClassName must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
            Class<?> implClass = Class.forName(className, false, tccl);
            Constructor<?> constructor = SecurityActions.getConstructor(implClass, argumentTypes);
            obj = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of " + className + ", missing package from classpath?", e);
        }
        try {
            return expectedType.cast(obj);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Incorrect expected type, " + expectedType.getName() + ", defined for " + obj.getClass().getName());
        }
    }

    static boolean isClassPresent(String name) {
        try {
            ClassLoader classLoader = SecurityActions.getThreadContextClassLoader();
            classLoader.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static Map<Integer, Annotation[]> getParametersWithAnnotation(final Method method, final Class<? extends Annotation> annotationClass) {
        Map<Integer, Annotation[]> declaredParameters = AccessController.doPrivileged(new PrivilegedAction<Map<Integer, Annotation[]>>(){

            @Override
            public Map<Integer, Annotation[]> run() {
                LinkedHashMap<Integer, Annotation[]> foundParameters = new LinkedHashMap<Integer, Annotation[]>();
                Class<?>[] parameterTypes = method.getParameterTypes();
                Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (!SecurityActions.isAnnotationPresent(parameterAnnotations[i], annotationClass)) continue;
                    foundParameters.put(i, parameterAnnotations[i]);
                }
                return foundParameters;
            }
        });
        return declaredParameters;
    }

    static List<Field> getFieldsWithAnnotation(final Class<?> source, final Class<? extends Annotation> annotationClass) {
        List<Field> declaredAccessableFields = AccessController.doPrivileged(new PrivilegedAction<List<Field>>(){

            @Override
            public List<Field> run() {
                ArrayList<Field> foundFields = new ArrayList<Field>();
                for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                    for (Field field : nextSource.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(annotationClass)) continue;
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        foundFields.add(field);
                    }
                }
                return foundFields;
            }
        });
        return declaredAccessableFields;
    }

    static boolean isAnnotationPresent(Annotation[] annotations, Class<? extends Annotation> needle) {
        return SecurityActions.findAnnotation(annotations, needle) != null;
    }

    static <T extends Annotation> T findAnnotation(Annotation[] annotations, Class<T> needle) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != needle) continue;
            return (T)annotation;
        }
        return null;
    }

    static Annotation[] getAnnotations(final AnnotatedElement element) {
        return AccessController.doPrivileged(new PrivilegedAction<Annotation[]>(){

            @Override
            public Annotation[] run() {
                return element.getDeclaredAnnotations();
            }
        });
    }

    static <T extends Annotation> T getAnnotation(final AnnotatedElement element, final Class<T> annotationClass) {
        return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return element.getAnnotation(annotationClass);
            }
        }));
    }

    static Class<? extends Annotation> getQualifier(final Field field) {
        Annotation[] annotations = AccessController.doPrivileged(new PrivilegedAction<Annotation[]>(){

            @Override
            public Annotation[] run() {
                return field.getAnnotations();
            }
        });
        return SecurityActions.getQualifier(annotations);
    }

    static Class<? extends Annotation> getScope(final AnnotatedElement element) {
        Annotation[] annotations = AccessController.doPrivileged(new PrivilegedAction<Annotation[]>(){

            @Override
            public Annotation[] run() {
                return element.getAnnotations();
            }
        });
        return SecurityActions.getScope(annotations);
    }

    static Object getFieldValue(final Object instance, final Field field) {
        try {
            Object value = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IllegalArgumentException, IllegalAccessException {
                    return field.get(instance);
                }
            });
            return value;
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            if (t instanceof IllegalAccessException) {
                throw new IllegalStateException("Unable to get field value of " + field.getName() + " due to: " + t.getMessage(), t.getCause());
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static void setFieldValue(final Object instance, final Field field, final Object value) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IllegalArgumentException, IllegalAccessException {
                    field.set(instance, value);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            if (t instanceof IllegalAccessException) {
                throw new IllegalStateException("Unable to set field value of " + field.getName() + " due to: " + t.getMessage(), t.getCause());
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static List<Class<? extends Annotation>> findAnnotationAnnotatedWith(Class<? extends Annotation> parentAnnotation, Annotation[] annotations) {
        ArrayList<Class<? extends Annotation>> candidates = new ArrayList<Class<? extends Annotation>>();
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(parentAnnotation)) continue;
            candidates.add(annotation.annotationType());
        }
        return candidates;
    }

    static Class<? extends Annotation> getQualifier(Annotation[] annotations) {
        List<Class<? extends Annotation>> candidates = SecurityActions.findAnnotationAnnotatedWith(Qualifier.class, annotations);
        if (candidates.isEmpty()) {
            return Default.class;
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        throw new IllegalStateException("Unable to determine Qualifier, multiple (" + candidates.size() + ") Qualifier annotations were present");
    }

    static Class<? extends Annotation> getScope(Annotation[] annotations) {
        List<Class<? extends Annotation>> candidates = SecurityActions.findAnnotationAnnotatedWith(DroneLifecycle.class, annotations);
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        throw new IllegalStateException("Unable to determine Lifecycle, multiple (" + candidates.size() + ") Lifecycle annotations were present");
    }

    static String getProperty(final String key) {
        try {
            String value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

