/*
 * Decompiled with CFR 0.152.
 */
package org.jamel.dbf.structure;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jamel.dbf.exception.DbfException;
import org.jamel.dbf.structure.DbfField;
import org.jamel.dbf.utils.DbfUtils;

public class DbfHeader {
    private byte signature;
    private byte year;
    private byte month;
    private byte day;
    private int numberOfRecords;
    private short headerLength;
    private short recordLength;
    private short reserv1;
    private byte incompleteTransaction;
    private byte encryptionFlag;
    private int freeRecordThread;
    private int reserv2;
    private int reserv3;
    private byte mdxFlag;
    private byte languageDriver;
    private short reserv4;
    private List<DbfField> fields;
    private Map<String, Integer> fieldIndexesByNames;

    public static DbfHeader read(DataInput dataInput) throws DbfException {
        try {
            DbfField field;
            DbfHeader header = new DbfHeader();
            header.signature = dataInput.readByte();
            header.year = dataInput.readByte();
            header.month = dataInput.readByte();
            header.day = dataInput.readByte();
            header.numberOfRecords = DbfUtils.readLittleEndianInt(dataInput);
            header.headerLength = DbfUtils.readLittleEndianShort(dataInput);
            header.recordLength = DbfUtils.readLittleEndianShort(dataInput);
            header.reserv1 = DbfUtils.readLittleEndianShort(dataInput);
            header.incompleteTransaction = dataInput.readByte();
            header.encryptionFlag = dataInput.readByte();
            header.freeRecordThread = DbfUtils.readLittleEndianInt(dataInput);
            header.reserv2 = dataInput.readInt();
            header.reserv3 = dataInput.readInt();
            header.mdxFlag = dataInput.readByte();
            header.languageDriver = dataInput.readByte();
            header.reserv4 = DbfUtils.readLittleEndianShort(dataInput);
            header.fields = new ArrayList<DbfField>();
            int fieldIndex = 0;
            while ((field = DbfField.read(dataInput, fieldIndex++)) != null) {
                header.fields.add(field);
            }
            return header;
        }
        catch (IOException e) {
            throw new DbfException("Cannot read Dbf header", e);
        }
    }

    public short getHeaderLength() {
        return this.headerLength;
    }

    public int getFieldsCount() {
        return this.fields.size();
    }

    public byte getYear() {
        return this.year;
    }

    public byte getMonth() {
        return this.month;
    }

    public byte getDay() {
        return this.day;
    }

    public DbfField getField(int i) {
        return this.fields.get(i);
    }

    public DbfField getField(String fieldName) {
        return this.getField(this.getFieldIndex(fieldName));
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public short getRecordLength() {
        return this.recordLength;
    }

    public int getFieldIndex(String fieldName) {
        Integer index;
        if (this.fieldIndexesByNames == null) {
            this.initFieldIndexesByNames();
        }
        return (index = this.fieldIndexesByNames.get(fieldName)) == null ? -1 : index;
    }

    private void initFieldIndexesByNames() {
        this.fieldIndexesByNames = new HashMap<String, Integer>(this.fields.size());
        for (int i = 0; i < this.fields.size(); ++i) {
            DbfField field = this.fields.get(i);
            this.fieldIndexesByNames.put(field.getName(), i);
        }
    }
}

