/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.hash;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.multimap.impl.EmbeddedMultimapPairCache;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.Resp3Response;

public class HINCRBYFLOAT
extends RespCommand
implements Resp3Command {
    private static final int SUCCESS = 0;
    private static final int NOT_A_FLOAT = 1;
    private static final int NAN_OR_INF = 2;

    public HINCRBYFLOAT() {
        super(4, 1, 1, 1);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        EmbeddedMultimapPairCache<byte[], byte[], byte[]> multimap = handler.getHashMapMultimap();
        double delta = ArgumentUtils.toDouble(arguments.get(2));
        if (!ArgumentUtils.isFloatValid(delta)) {
            RespErrorUtil.nanOrInfinity(handler.allocator());
            return handler.myStage();
        }
        AtomicInteger status = new AtomicInteger(0);
        CompletionStage cs = multimap.compute((Object)arguments.get(0), (Object)arguments.get(1), (ignore, prev) -> {
            if (prev == null) {
                return (byte[])arguments.get(2);
            }
            try {
                double prevDouble = ArgumentUtils.toDouble(prev);
                double after = prevDouble + delta;
                if (!ArgumentUtils.isFloatValid(after)) {
                    status.set(2);
                    return prev;
                }
                return ArgumentUtils.toByteArray(prevDouble + delta);
            }
            catch (NumberFormatException nfe) {
                status.set(1);
                return prev;
            }
        });
        return handler.stageToReturn(cs, ctx, (res, alloc) -> {
            switch (status.get()) {
                case 1: {
                    RespErrorUtil.customError("hash value is not a float", alloc);
                    break;
                }
                case 2: {
                    RespErrorUtil.nanOrInfinity(alloc);
                    break;
                }
                default: {
                    Resp3Response.string(res, alloc);
                }
            }
        });
    }
}

