/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk.auth;

import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.configuration.AuthenticationConfiguration;
import org.infinispan.client.rest.impl.jdk.auth.HttpAuthenticator;

public class BasicAuthenticator
extends HttpAuthenticator {
    private final String authzValue;

    public BasicAuthenticator(HttpClient client, AuthenticationConfiguration configuration) {
        super(client, configuration);
        this.authzValue = BasicAuthenticator.basic(configuration.username(), new String(configuration.password()));
    }

    @Override
    public boolean supportsPreauthentication() {
        return true;
    }

    @Override
    public HttpRequest.Builder preauthenticate(HttpRequest.Builder request) {
        return request.header("Authorization", this.authzValue);
    }

    @Override
    public <T> CompletionStage<HttpResponse<T>> authenticate(HttpResponse<T> response, HttpResponse.BodyHandler<?> bodyHandler) {
        HttpRequest request = response.request();
        List<String> authorization = request.headers().allValues("Authorization");
        if (!authorization.isEmpty() && authorization.get(0).startsWith("Basic")) {
            return null;
        }
        HttpRequest.Builder newRequest = BasicAuthenticator.copyRequest(request, (n, v) -> true).header("Authorization", this.authzValue);
        return this.client.sendAsync(newRequest.build(), bodyHandler);
    }

    public static String basic(String username, String password) {
        String usernameAndPassword = username + ":" + password;
        String encoded = Base64.getEncoder().encodeToString(usernameAndPassword.getBytes(StandardCharsets.ISO_8859_1));
        return "Basic " + encoded;
    }
}

