/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.compiler;

import java.util.HashMap;
import javax.xml.transform.TransformerException;
import org.htmlunit.xpath.functions.FuncBoolean;
import org.htmlunit.xpath.functions.FuncCeiling;
import org.htmlunit.xpath.functions.FuncConcat;
import org.htmlunit.xpath.functions.FuncContains;
import org.htmlunit.xpath.functions.FuncCount;
import org.htmlunit.xpath.functions.FuncFalse;
import org.htmlunit.xpath.functions.FuncFloor;
import org.htmlunit.xpath.functions.FuncId;
import org.htmlunit.xpath.functions.FuncLang;
import org.htmlunit.xpath.functions.FuncLast;
import org.htmlunit.xpath.functions.FuncLocalPart;
import org.htmlunit.xpath.functions.FuncNamespace;
import org.htmlunit.xpath.functions.FuncNormalizeSpace;
import org.htmlunit.xpath.functions.FuncNot;
import org.htmlunit.xpath.functions.FuncNumber;
import org.htmlunit.xpath.functions.FuncPosition;
import org.htmlunit.xpath.functions.FuncQname;
import org.htmlunit.xpath.functions.FuncRound;
import org.htmlunit.xpath.functions.FuncStartsWith;
import org.htmlunit.xpath.functions.FuncString;
import org.htmlunit.xpath.functions.FuncStringLength;
import org.htmlunit.xpath.functions.FuncSubstring;
import org.htmlunit.xpath.functions.FuncSubstringAfter;
import org.htmlunit.xpath.functions.FuncSubstringBefore;
import org.htmlunit.xpath.functions.FuncSum;
import org.htmlunit.xpath.functions.FuncTranslate;
import org.htmlunit.xpath.functions.FuncTrue;
import org.htmlunit.xpath.functions.Function;

public class FunctionTable {
    public static final int FUNC_CURRENT = 0;
    public static final int FUNC_LAST = 1;
    public static final int FUNC_POSITION = 2;
    public static final int FUNC_COUNT = 3;
    public static final int FUNC_ID = 4;
    public static final int FUNC_LOCAL_PART = 7;
    public static final int FUNC_NAMESPACE = 8;
    public static final int FUNC_QNAME = 9;
    public static final int FUNC_NOT = 11;
    public static final int FUNC_TRUE = 12;
    public static final int FUNC_FALSE = 13;
    public static final int FUNC_BOOLEAN = 14;
    public static final int FUNC_NUMBER = 15;
    public static final int FUNC_FLOOR = 16;
    public static final int FUNC_CEILING = 17;
    public static final int FUNC_ROUND = 18;
    public static final int FUNC_SUM = 19;
    public static final int FUNC_STRING = 20;
    public static final int FUNC_STARTS_WITH = 21;
    public static final int FUNC_CONTAINS = 22;
    public static final int FUNC_SUBSTRING_BEFORE = 23;
    public static final int FUNC_SUBSTRING_AFTER = 24;
    public static final int FUNC_NORMALIZE_SPACE = 25;
    public static final int FUNC_TRANSLATE = 26;
    public static final int FUNC_CONCAT = 27;
    public static final int FUNC_SUBSTRING = 29;
    public static final int FUNC_STRING_LENGTH = 30;
    public static final int FUNC_LANG = 32;
    private static final Class<?>[] m_functions;
    private static final HashMap<String, Integer> m_functionID;
    private final Class<?>[] m_functions_customer = new Class[30];
    private final HashMap<String, Integer> m_functionID_customer = new HashMap();
    private static final int NUM_BUILT_IN_FUNCS = 37;
    private static final int NUM_ALLOWABLE_ADDINS = 30;
    private int m_funcNextFreeIndex = 37;

    String getFunctionName(int funcID) {
        if (funcID < 37) {
            return m_functions[funcID].getSimpleName();
        }
        return this.m_functions_customer[funcID - 37].getName();
    }

    Function getFunction(int which) throws TransformerException {
        try {
            if (which < 37) {
                return (Function)m_functions[which].newInstance();
            }
            return (Function)this.m_functions_customer[which - 37].newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new TransformerException(ex.getMessage());
        }
    }

    Object getFunctionID(String key) {
        Integer id = this.m_functionID_customer.get(key);
        if (null == id) {
            id = m_functionID.get(key);
        }
        return id;
    }

    public int installFunction(String name, Class<?> func) {
        int funcIndex;
        Object funcIndexObj = this.getFunctionID(name);
        if (null != funcIndexObj) {
            funcIndex = (Integer)funcIndexObj;
            if (funcIndex < 37) {
                funcIndex = this.m_funcNextFreeIndex++;
                this.m_functionID_customer.put(name, funcIndex);
            }
            this.m_functions_customer[funcIndex - 37] = func;
        } else {
            funcIndex = this.m_funcNextFreeIndex++;
            this.m_functions_customer[funcIndex - 37] = func;
            this.m_functionID_customer.put(name, funcIndex);
        }
        return funcIndex;
    }

    public boolean functionAvailable(String methName) {
        Integer tblEntry = m_functionID.get(methName);
        if (null != tblEntry) {
            return true;
        }
        tblEntry = this.m_functionID_customer.get(methName);
        return null != tblEntry;
    }

    static {
        m_functionID = new HashMap();
        m_functions = new Class[37];
        FunctionTable.m_functions[1] = FuncLast.class;
        FunctionTable.m_functions[2] = FuncPosition.class;
        FunctionTable.m_functions[3] = FuncCount.class;
        FunctionTable.m_functions[4] = FuncId.class;
        FunctionTable.m_functions[7] = FuncLocalPart.class;
        FunctionTable.m_functions[8] = FuncNamespace.class;
        FunctionTable.m_functions[9] = FuncQname.class;
        FunctionTable.m_functions[11] = FuncNot.class;
        FunctionTable.m_functions[12] = FuncTrue.class;
        FunctionTable.m_functions[13] = FuncFalse.class;
        FunctionTable.m_functions[14] = FuncBoolean.class;
        FunctionTable.m_functions[32] = FuncLang.class;
        FunctionTable.m_functions[15] = FuncNumber.class;
        FunctionTable.m_functions[16] = FuncFloor.class;
        FunctionTable.m_functions[17] = FuncCeiling.class;
        FunctionTable.m_functions[18] = FuncRound.class;
        FunctionTable.m_functions[19] = FuncSum.class;
        FunctionTable.m_functions[20] = FuncString.class;
        FunctionTable.m_functions[21] = FuncStartsWith.class;
        FunctionTable.m_functions[22] = FuncContains.class;
        FunctionTable.m_functions[23] = FuncSubstringBefore.class;
        FunctionTable.m_functions[24] = FuncSubstringAfter.class;
        FunctionTable.m_functions[25] = FuncNormalizeSpace.class;
        FunctionTable.m_functions[26] = FuncTranslate.class;
        FunctionTable.m_functions[27] = FuncConcat.class;
        FunctionTable.m_functions[29] = FuncSubstring.class;
        FunctionTable.m_functions[30] = FuncStringLength.class;
        m_functionID.put("current", 0);
        m_functionID.put("last", 1);
        m_functionID.put("position", 2);
        m_functionID.put("count", 3);
        m_functionID.put("id", 4);
        m_functionID.put("local-name", 7);
        m_functionID.put("namespace-uri", 8);
        m_functionID.put("name", 9);
        m_functionID.put("not", 11);
        m_functionID.put("true", 12);
        m_functionID.put("false", 13);
        m_functionID.put("boolean", 14);
        m_functionID.put("lang", 32);
        m_functionID.put("number", 15);
        m_functionID.put("floor", 16);
        m_functionID.put("ceiling", 17);
        m_functionID.put("round", 18);
        m_functionID.put("sum", 19);
        m_functionID.put("string", 20);
        m_functionID.put("starts-with", 21);
        m_functionID.put("contains", 22);
        m_functionID.put("substring-before", 23);
        m_functionID.put("substring-after", 24);
        m_functionID.put("normalize-space", 25);
        m_functionID.put("translate", 26);
        m_functionID.put("concat", 27);
        m_functionID.put("substring", 29);
        m_functionID.put("string-length", 30);
    }
}

