/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.value;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public final class Scheme {
    private final String value_;

    private Scheme(String value) {
        this.value_ = value;
    }

    public static Optional<Scheme> parseScheme(String value) {
        if (value.matches("^[a-zA-Z][a-zA-Z0-9+\\-.]*:$")) {
            return Optional.of(new Scheme(value.substring(0, value.length() - 1).toLowerCase(Locale.ROOT)));
        }
        return Optional.empty();
    }

    public String getValue() {
        return this.value_;
    }

    public String toString() {
        return this.value_ + ":";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scheme scheme = (Scheme)o;
        return this.value_.equals(scheme.value_);
    }

    public int hashCode() {
        return Objects.hash(this.value_);
    }
}

