/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.search.impl.AbstractLuceneSearchValueFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneTextPhrasePredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private LuceneTextPhrasePredicate(Builder builder) {
        super(builder);
    }

    private static class Builder<F>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements PhrasePredicateBuilder {
        private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
        private int slop;
        private String phrase;
        private Analyzer overrideAnalyzer;

        private Builder(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            super(searchContext, field);
            this.analysisDefinitionRegistry = searchContext.analysisDefinitionRegistry();
        }

        public void slop(int slop) {
            this.slop = slop;
        }

        public void phrase(String phrase) {
            this.phrase = phrase;
        }

        public void analyzer(String analyzerName) {
            this.overrideAnalyzer = this.analysisDefinitionRegistry.getAnalyzerDefinition(analyzerName);
            if (this.overrideAnalyzer == null) {
                throw log.unknownAnalyzer(analyzerName, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
            }
        }

        public void skipAnalysis() {
            this.overrideAnalyzer = AnalyzerConstants.KEYWORD_ANALYZER;
        }

        public SearchPredicate build() {
            return new LuceneTextPhrasePredicate(this);
        }

        @Override
        protected Query buildQuery() {
            Analyzer effectiveAnalyzerOrNormalizer = this.overrideAnalyzer;
            if (effectiveAnalyzerOrNormalizer == null) {
                effectiveAnalyzerOrNormalizer = this.field.type().searchAnalyzerOrNormalizer();
            }
            if (effectiveAnalyzerOrNormalizer == AnalyzerConstants.KEYWORD_ANALYZER) {
                return new TermQuery(new Term(this.absoluteFieldPath, this.phrase));
            }
            Query analyzed = new QueryBuilder(effectiveAnalyzerOrNormalizer).createPhraseQuery(this.absoluteFieldPath, this.phrase, this.slop);
            if (analyzed == null) {
                analyzed = new MatchNoDocsQuery("No tokens after analysis of the phrase to match");
            }
            return analyzed;
        }
    }

    public static class Factory<F>
    extends AbstractLuceneSearchValueFieldQueryElementFactory<PhrasePredicateBuilder, F> {
        @Override
        public Builder<F> create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            return new Builder(searchContext, field);
        }
    }
}

