/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.Version;

public final class PassThroughAnalyzer
extends Analyzer {
    private final Version luceneVersion;

    public PassThroughAnalyzer(Version luceneVersion) {
        this.luceneVersion = luceneVersion;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        if (this.luceneVersion.onOrAfter(Version.LUCENE_31)) {
            return new PassThroughTokenizer(this.luceneVersion, reader);
        }
        return new Pre31PassThroughTokenizer(this.luceneVersion, reader);
    }

    private static class Pre31PassThroughTokenizer
    extends CharTokenizer {
        public Pre31PassThroughTokenizer(Version luceneVersion, Reader input) {
            super(luceneVersion, input);
        }

        protected boolean isTokenChar(char c) {
            return true;
        }
    }

    private static class PassThroughTokenizer
    extends CharTokenizer {
        public PassThroughTokenizer(Version luceneVersion, Reader input) {
            super(luceneVersion, input);
        }

        protected boolean isTokenChar(int c) {
            return true;
        }
    }
}

