/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.util.List;
import org.hibernate.search.backend.impl.jgroups.NodeSelectorStrategy;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;

public class AutoNodeSelector
implements NodeSelectorStrategy {
    private final String indexName;
    private volatile Address localAddress;
    private volatile Address masterAddress;

    public AutoNodeSelector(String indexName) {
        this.indexName = indexName;
    }

    @Override
    public boolean isIndexOwnerLocal() {
        return this.localAddress == null || this.localAddress.equals(this.masterAddress);
    }

    @Override
    public void setLocalAddress(Address address) {
        this.localAddress = address;
    }

    @Override
    public void viewAccepted(View view) {
        List members = view.getMembers();
        if (members.size() == 1) {
            this.masterAddress = (Address)members.get(0);
        } else if (members.size() == 2) {
            this.masterAddress = (Address)members.get(1);
        } else {
            int selectionRange = members.size() - 1;
            int selected = Math.abs(this.indexName.hashCode() % selectionRange) + 1;
            this.masterAddress = (Address)members.get(selected);
        }
    }

    @Override
    public Message createMessage(byte[] data) {
        return new Message(null, this.localAddress, data);
    }
}

