/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.expression;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.criteria.ParameterContainer;
import org.hibernate.jpa.criteria.ParameterRegistry;
import org.hibernate.jpa.criteria.Renderable;
import org.hibernate.jpa.criteria.compile.RenderingContext;
import org.hibernate.jpa.criteria.expression.ExpressionImpl;
import org.hibernate.jpa.criteria.expression.UnaryOperatorExpression;

public class UnaryArithmeticOperation<T>
extends ExpressionImpl<T>
implements UnaryOperatorExpression<T>,
Serializable {
    private final Operation operation;
    private final Expression<T> operand;

    public UnaryArithmeticOperation(CriteriaBuilderImpl criteriaBuilder, Operation operation, Expression<T> operand) {
        super(criteriaBuilder, operand.getJavaType());
        this.operation = operation;
        this.operand = operand;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public Expression<T> getOperand() {
        return this.operand;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getOperand(), registry);
    }

    @Override
    public String render(RenderingContext renderingContext) {
        return (this.getOperation() == Operation.UNARY_MINUS ? (char)'-' : '+') + ((Renderable)this.getOperand()).render(renderingContext);
    }

    @Override
    public String renderProjection(RenderingContext renderingContext) {
        return this.render(renderingContext);
    }

    public static enum Operation {
        UNARY_PLUS,
        UNARY_MINUS;

    }
}

