/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab.api.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.gitlab.api.models.GitlabAccessLevel;

public class Query {
    private final List<Tuple<String, Tuple<String, String>>> params = new ArrayList<Tuple<String, Tuple<String, String>>>();

    public Query append(String name, String value) throws UnsupportedEncodingException {
        this.params.add(new Tuple<String, Tuple<String, String>>(name, new Tuple<String, String>(value, URLEncoder.encode(value, "UTF-8"))));
        return this;
    }

    public <T> Query appendIf(String name, T value) throws UnsupportedEncodingException {
        if (value != null) {
            this.append(name, value.toString());
        }
        return this;
    }

    public Query appendIf(String name, GitlabAccessLevel value) throws UnsupportedEncodingException {
        if (value != null) {
            this.append(name, Integer.toString(value.accessValue));
        }
        return this;
    }

    public boolean mergeWith(Query query) {
        return this.params.addAll(query.params);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Tuple<String, Tuple<String, String>> param : this.params) {
            if (builder.length() == 0) {
                builder.append('?');
            } else {
                builder.append('&');
            }
            builder.append((String)param._1);
            builder.append('=');
            builder.append((String)((Tuple)param._2)._2);
        }
        return builder.toString();
    }

    private class Tuple<T1, T2> {
        T1 _1;
        T2 _2;

        public Tuple(T1 _1, T2 _2) {
            this._1 = _1;
            this._2 = _2;
        }
    }
}

