/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Arrays;
import java.util.List;
import org.geolatte.geom.G3D;
import org.geolatte.geom.G3DM;
import org.geolatte.geom.crs.CoordinateSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.EllipsoidalAxis;
import org.geolatte.geom.crs.EllipsoidalCoordinateSystem3DM;
import org.geolatte.geom.crs.MeasureStraightLineAxis;
import org.geolatte.geom.crs.OneDimensionCoordinateSystem;
import org.geolatte.geom.crs.StraightLineAxis;

public class EllipsoidalCoordinateSystem3D
extends CoordinateSystem<G3D> {
    private static final List<Integer> REQUIRED_AXIS_NORMAL_ORDER = Arrays.asList(0, 1, 2);

    public EllipsoidalCoordinateSystem3D(EllipsoidalAxis first, EllipsoidalAxis second, StraightLineAxis heightAxis) {
        super(first, second, heightAxis);
        this.checkAxes();
    }

    private void checkAxes() {
        List<Integer> order = this.getAxisNormalOrder();
        if (!order.containsAll(REQUIRED_AXIS_NORMAL_ORDER)) {
            throw new IllegalArgumentException("Require order 0, 1 and 2 axes");
        }
    }

    @Override
    public Class<G3D> getPositionClass() {
        return G3D.class;
    }

    @Override
    public CoordinateSystem<G3DM> merge(OneDimensionCoordinateSystem<?> coordinateSystem) {
        CoordinateSystemAxis axis = coordinateSystem.getAxis();
        return this.extend(axis);
    }

    @Override
    public CoordinateSystem<G3DM> extend(CoordinateSystemAxis axis) {
        if (axis instanceof MeasureStraightLineAxis) {
            return new EllipsoidalCoordinateSystem3DM((EllipsoidalAxis)this.getAxis(0), (EllipsoidalAxis)this.getAxis(1), (StraightLineAxis)this.getAxis(2), (MeasureStraightLineAxis)axis);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasZ() {
        return true;
    }

    @Override
    public boolean hasM() {
        return false;
    }
}

