/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.io.Serializable;
import java.util.Objects;
import org.geolatte.geom.crs.CoordinateSystemAxisDirection;
import org.geolatte.geom.crs.GeodeticLatitudeCSAxis;
import org.geolatte.geom.crs.GeodeticLongitudeCSAxis;
import org.geolatte.geom.crs.StraightLineAxis;
import org.geolatte.geom.crs.Unit;

public abstract class CoordinateSystemAxis
implements Serializable {
    private static final long serialVersionUID = 6884205871950410216L;
    private final String axisName;
    private final CoordinateSystemAxisDirection coordinateSystemAxisDirection;
    private final Unit unit;
    private final int normalOrder;

    public static GeodeticLongitudeCSAxis mkLonAxis() {
        return new GeodeticLongitudeCSAxis("Longitude", Unit.DEGREE);
    }

    public static GeodeticLatitudeCSAxis mkLatAxis() {
        return new GeodeticLatitudeCSAxis("Latitude", Unit.DEGREE);
    }

    public static StraightLineAxis mkXAxis() {
        return new StraightLineAxis("X", CoordinateSystemAxisDirection.EAST, Unit.METER);
    }

    public static StraightLineAxis mkYAxis() {
        return new StraightLineAxis("Y", CoordinateSystemAxisDirection.NORTH, Unit.METER);
    }

    public static StraightLineAxis mkZAxis() {
        return new StraightLineAxis("Z", CoordinateSystemAxisDirection.UP, Unit.METER);
    }

    CoordinateSystemAxis(String axisName, CoordinateSystemAxisDirection coordinateSystemAxisDirection, Unit unit) {
        this.axisName = axisName;
        this.coordinateSystemAxisDirection = coordinateSystemAxisDirection;
        this.unit = unit;
        this.normalOrder = coordinateSystemAxisDirection.getDefaultNormalOrder();
    }

    CoordinateSystemAxis(String axisName, CoordinateSystemAxisDirection coordinateSystemAxisDirection, int normalOrder, Unit unit) {
        this.axisName = axisName;
        this.coordinateSystemAxisDirection = coordinateSystemAxisDirection;
        this.unit = unit;
        this.normalOrder = normalOrder;
    }

    public String getAxisName() {
        return this.axisName;
    }

    public CoordinateSystemAxisDirection getAxisDirection() {
        return this.coordinateSystemAxisDirection;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int getNormalOrder() {
        return this.normalOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        CoordinateSystemAxis that = (CoordinateSystemAxis)o;
        if (!Objects.equals(this.axisName, that.axisName)) {
            return false;
        }
        if (this.coordinateSystemAxisDirection != that.coordinateSystemAxisDirection) {
            return false;
        }
        if (this.normalOrder != that.normalOrder) {
            return false;
        }
        return Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        int result = this.axisName != null ? this.axisName.hashCode() : 0;
        result = 31 * result + (this.coordinateSystemAxisDirection != null ? this.coordinateSystemAxisDirection.hashCode() : 0);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CoordinateSystemAxis{axisName='" + this.axisName + '\'' + ", coordinateSystemAxisDirection=" + (Object)((Object)this.coordinateSystemAxisDirection) + ", unit=" + this.unit + '}';
    }
}

