/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Arrays;
import java.util.List;
import org.geolatte.geom.C2DM;
import org.geolatte.geom.C3DM;
import org.geolatte.geom.crs.CartesianCoordinateSystem3DM;
import org.geolatte.geom.crs.CoordinateSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.MeasureStraightLineAxis;
import org.geolatte.geom.crs.OneDimensionCoordinateSystem;
import org.geolatte.geom.crs.StraightLineAxis;
import org.geolatte.geom.crs.VerticalStraightLineAxis;

public class CartesianCoordinateSystem2DM
extends CoordinateSystem<C2DM> {
    private static final List<Integer> REQUIRED_AXIS_NORMAL_ORDER = Arrays.asList(0, 1, 3);

    public CartesianCoordinateSystem2DM(StraightLineAxis firstAxis, StraightLineAxis secondAxis, MeasureStraightLineAxis thirdAxis) {
        super(firstAxis, secondAxis, thirdAxis);
        this.checkAxes();
    }

    private void checkAxes() {
        List<Integer> order = this.getAxisNormalOrder();
        if (!order.containsAll(REQUIRED_AXIS_NORMAL_ORDER)) {
            throw new IllegalArgumentException("Require order 0, 1 and 3 axes");
        }
    }

    @Override
    public Class<C2DM> getPositionClass() {
        return C2DM.class;
    }

    @Override
    public CoordinateSystem<C3DM> merge(OneDimensionCoordinateSystem<?> coordinateSystem) {
        CoordinateSystemAxis axis = coordinateSystem.getAxis();
        return this.extend(axis);
    }

    @Override
    public CoordinateSystem<C3DM> extend(CoordinateSystemAxis axis) {
        if (axis instanceof VerticalStraightLineAxis) {
            return new CartesianCoordinateSystem3DM((StraightLineAxis)this.getAxis(0), (StraightLineAxis)this.getAxis(1), (VerticalStraightLineAxis)axis, (MeasureStraightLineAxis)this.getAxis(2));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasZ() {
        return false;
    }

    @Override
    public boolean hasM() {
        return true;
    }
}

