/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.db2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.codec.WktDecoder;
import org.geolatte.geom.codec.db.Decoder;

public class Db2ClobDecoder
implements Decoder<Clob> {
    private final Integer srid;

    public Db2ClobDecoder(Integer srid) {
        this.srid = srid;
    }

    @Override
    public Geometry<?> decode(Clob clob) {
        String wkt = this.clobToString(clob);
        WktDecoder decoder = Wkt.newDecoder(Wkt.Dialect.DB2_WKT);
        if (wkt.substring(0, 4).toUpperCase().startsWith("SRID")) {
            return decoder.decode(wkt);
        }
        return decoder.decode(String.format("SRID=%d;%s", this.srid, wkt));
    }

    @Override
    public boolean accepts(Clob clob) {
        return true;
    }

    private String clobToString(Clob clob) {
        InputStream in = null;
        InputStreamReader in2 = null;
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        try {
            int read;
            in = clob.getAsciiStream();
            in2 = new InputStreamReader(in);
            do {
                if ((read = ((Reader)in2).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (in2 != null) {
                    ((Reader)in2).close();
                }
            }
            catch (IOException iOException) {}
        }
        return out.toString();
    }
}

