/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.BaseWkbVisitor;
import org.geolatte.geom.codec.HANAWkbVisitor;
import org.geolatte.geom.codec.WkbDialect;

class HANAWkbDialect
extends WkbDialect {
    public static final HANAWkbDialect INSTANCE = new HANAWkbDialect();

    private HANAWkbDialect() {
    }

    @Override
    boolean emptyPointAsNaN() {
        return false;
    }

    @Override
    GeometryType parseType(long tpe) {
        return super.parseType((tpe & 0xFFFFL) % 100L);
    }

    @Override
    protected <P extends Position> int calculateSize(Geometry<P> geom, boolean includeSrid) {
        int size = 5;
        if (includeSrid) {
            size += 4;
        }
        if (geom.isEmpty()) {
            return size + 4;
        }
        if (geom instanceof AbstractGeometryCollection) {
            size += this.sizeOfGeometryCollection((AbstractGeometryCollection)geom);
        } else if (geom instanceof Polygon) {
            size += this.getPolygonSize((Polygon)geom);
        } else if (geom instanceof Point) {
            size += this.getPositionSize(geom);
        } else {
            size += 4;
            size += this.getPositionSize(geom) * geom.getNumPositions();
        }
        return size;
    }

    @Override
    <P extends Position> BaseWkbVisitor<P> mkVisitor(Geometry<P> geom, ByteOrder bo) {
        return new HANAWkbVisitor(this.mkByteBuffer(geom, bo), this);
    }
}

