/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.UnsupportedConversionException;
import org.geolatte.geom.codec.WktDialect;

class BaseWktWriter {
    private final StringBuilder builder;
    private final WktDialect dialect;

    public BaseWktWriter(WktDialect variant, StringBuilder builder) {
        this.dialect = variant;
        this.builder = builder;
    }

    public <P extends Position> String writeGeometry(Geometry<P> geometry) {
        this.addSrid(geometry.getSRID());
        this.addGeometry(geometry, true);
        return this.result();
    }

    protected void addSrid(int srid) {
        this.dialect.addSrid(this.builder, srid);
    }

    protected <P extends Position> void addGeometry(Geometry<P> geometry, boolean topLevel) {
        this.addGeometryTag(geometry);
        this.addGeometryZMMarker(geometry);
        this.addGeometryText(geometry);
    }

    protected void addGeometryTag(Geometry<?> geometry) {
        this.dialect.addGeometryTag(this.builder, geometry);
    }

    protected void addGeometryZMMarker(Geometry<?> geometry) {
        this.dialect.addGeometryZMMarker(this.builder, geometry);
    }

    protected <P extends Position> void addGeometryText(Geometry<P> geometry) {
        if (geometry.isEmpty()) {
            this.addEmptyKeyword();
            return;
        }
        GeometryType type = geometry.getGeometryType();
        switch (type) {
            case POINT: 
            case LINESTRING: 
            case LINEARRING: {
                this.addPointList(geometry.getPositions());
                break;
            }
            case POLYGON: {
                this.addStartList();
                this.addLinearRings((Polygon)geometry);
                this.addEndList();
                break;
            }
            case GEOMETRYCOLLECTION: {
                this.addStartList();
                this.addGeometries((AbstractGeometryCollection)geometry, true);
                this.addEndList();
                break;
            }
            case MULTIPOINT: {
                this.addMultiPointText(geometry);
                break;
            }
            case MULTILINESTRING: 
            case MULTIPOLYGON: {
                this.addStartList();
                this.addGeometries((AbstractGeometryCollection)geometry, false);
                this.addEndList();
                break;
            }
            default: {
                throw new UnsupportedConversionException(String.format("Geometry type %s not supported.", new Object[]{type}));
            }
        }
    }

    protected <P extends Position> void addMultiPointText(Geometry<P> geometry) {
        if (this.dialect.writeMultiPointAsListOfPositions()) {
            this.addPointList(geometry.getPositions());
        } else {
            this.addStartList();
            this.addGeometries((AbstractGeometryCollection)geometry, false);
            this.addEndList();
        }
    }

    protected <P extends Position, G extends Geometry<P>> void addGeometries(AbstractGeometryCollection<P, G> collection, boolean withTag) {
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            if (i > 0) {
                this.addDelimiter();
            }
            G geom = collection.getGeometryN(i);
            if (withTag) {
                this.addGeometry((Geometry<P>)geom, false);
                continue;
            }
            this.addGeometryText((Geometry<P>)geom);
        }
    }

    protected <P extends Position> void addLinearRings(Polygon<P> geometry) {
        this.addRing(geometry.getExteriorRing());
        for (int i = 0; i < geometry.getNumInteriorRing(); ++i) {
            this.addDelimiter();
            this.addRing(geometry.getInteriorRingN(i));
        }
    }

    protected <P extends Position> void addRing(LinearRing<P> ring) {
        this.addPointList(ring.getPositions());
    }

    protected <P extends Position> void addPointList(PositionSequence<P> points) {
        this.addStartList();
        this.addPositions(points);
        this.addEndList();
    }

    protected <P extends Position> double[] createCoordinateBuffer(PositionSequence<P> positions) {
        if (this.dialect.isLimitedTo2D()) {
            return new double[2];
        }
        return new double[positions.getCoordinateDimension()];
    }

    protected <P extends Position> void setCoordinatesToWrite(PositionSequence<P> positions, int pos, double[] coords) {
        if (this.dialect.isLimitedTo2D()) {
            coords[0] = ((Position)positions.getPositionN(pos)).getCoordinate(0);
            coords[1] = ((Position)positions.getPositionN(pos)).getCoordinate(1);
        } else {
            for (int i = 0; i < positions.getCoordinateDimension(); ++i) {
                coords[i] = ((Position)positions.getPositionN(pos)).getCoordinate(i);
            }
        }
    }

    private <P extends Position> void addPositions(PositionSequence<P> positions) {
        double[] coords = this.createCoordinateBuffer(positions);
        for (int i = 0; i < positions.size(); ++i) {
            if (i > 0) {
                this.addDelimiter();
            }
            this.setCoordinatesToWrite(positions, i, coords);
            for (int k = 0; k < coords.length; ++k) {
                if (k > 0) {
                    this.builder.append(' ');
                }
                this.builder.append(this.formatCoordinate(coords[k]));
            }
        }
    }

    private String formatCoordinate(double coord) {
        if (coord == (double)((long)coord)) {
            return String.valueOf((long)coord);
        }
        return String.valueOf(coord);
    }

    private void addEndList() {
        this.builder.append(')');
    }

    private void addDelimiter() {
        this.builder.append(",");
    }

    private void addStartList() {
        this.builder.append("(");
    }

    private void addEmptyKeyword() {
        this.builder.append(" EMPTY");
    }

    private String result() {
        return this.builder.toString();
    }
}

