/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.net.ConnectException;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionUpgrader;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.ClientUpgradeResponse;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.client.io.WebSocketClientConnection;
import org.eclipse.jetty.websocket.common.AcceptHash;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;

public class WebSocketUpgradeRequest
extends HttpRequest
implements Response.CompleteListener,
HttpConnectionUpgrader {
    private static final Logger LOG = Log.getLogger(WebSocketUpgradeRequest.class);
    private final WebSocketClient wsClient;
    private final EventDriver localEndpoint;
    private final CompletableFuture<Session> fut;
    private final ClientUpgradeRequestFacade apiRequestFacade = new ClientUpgradeRequestFacade();
    private UpgradeListener upgradeListener;

    protected WebSocketUpgradeRequest(WebSocketClient wsClient, HttpClient httpClient, ClientUpgradeRequest request) {
        this(wsClient, httpClient, request.getRequestURI(), request.getLocalEndpoint());
        this.apiRequestFacade.init(request);
    }

    public WebSocketUpgradeRequest(WebSocketClient wsClient, HttpClient httpClient, URI wsURI, Object localEndpoint) {
        super(httpClient, new HttpConversation(), wsURI);
        if (!wsURI.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be an absolute URI: " + wsURI);
        }
        String scheme = wsURI.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("ws") && !scheme.equalsIgnoreCase("wss")) {
            throw new IllegalArgumentException("WebSocket URI must use 'ws' or 'wss' scheme: " + wsURI);
        }
        this.wsClient = wsClient;
        try {
            if (!this.wsClient.isRunning()) {
                this.wsClient.start();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to start WebSocketClient", e);
        }
        this.localEndpoint = this.wsClient.getEventDriverFactory().wrap(localEndpoint);
        this.fut = new CompletableFuture();
    }

    private final String genRandomKey() {
        byte[] bytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(bytes);
        return new String(B64Code.encode((byte[])bytes));
    }

    private ExtensionFactory getExtensionFactory() {
        return this.wsClient.getExtensionFactory();
    }

    private SessionFactory getSessionFactory() {
        return this.wsClient.getSessionFactory();
    }

    private void initWebSocketHeaders() {
        this.method(HttpMethod.GET);
        this.version(HttpVersion.HTTP_1_1);
        this.header(HttpHeader.UPGRADE, "websocket");
        this.header(HttpHeader.CONNECTION, "Upgrade");
        this.header(HttpHeader.SEC_WEBSOCKET_KEY, this.genRandomKey());
        this.header(HttpHeader.SEC_WEBSOCKET_VERSION, "13");
        this.header(HttpHeader.PRAGMA, "no-cache");
        this.header(HttpHeader.CACHE_CONTROL, "no-cache");
        if (!this.apiRequestFacade.getExtensions().isEmpty()) {
            for (ExtensionConfig ext : this.apiRequestFacade.getExtensions()) {
                this.header(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, ext.getParameterizedName());
            }
        }
        if (!this.apiRequestFacade.getSubProtocols().isEmpty()) {
            for (String protocol : this.apiRequestFacade.getSubProtocols()) {
                this.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, protocol);
            }
        }
        if (this.upgradeListener != null) {
            this.upgradeListener.onHandshakeRequest(this.apiRequestFacade);
        }
    }

    public void onComplete(Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onComplete() - {}", new Object[]{result});
        }
        URI requestURI = result.getRequest().getURI();
        Response response = result.getResponse();
        int responseStatusCode = response.getStatus();
        String responseLine = responseStatusCode + " " + response.getReason();
        if (result.isFailed()) {
            Throwable failure;
            if (LOG.isDebugEnabled()) {
                if (result.getFailure() != null) {
                    LOG.debug("General Failure", result.getFailure());
                }
                if (result.getRequestFailure() != null) {
                    LOG.debug("Request Failure", result.getRequestFailure());
                }
                if (result.getResponseFailure() != null) {
                    LOG.debug("Response Failure", result.getResponseFailure());
                }
            }
            if ((failure = result.getFailure()) instanceof ConnectException || failure instanceof UpgradeException) {
                this.handleException(failure);
            } else {
                this.handleException((Throwable)new UpgradeException(requestURI, responseStatusCode, responseLine, failure));
            }
        }
        if (responseStatusCode != 101) {
            this.handleException((Throwable)new UpgradeException(requestURI, responseStatusCode, responseLine));
        }
    }

    private void handleException(Throwable failure) {
        this.localEndpoint.incomingError(failure);
        this.fut.completeExceptionally(failure);
    }

    public ContentResponse send() throws InterruptedException, TimeoutException, ExecutionException {
        throw new RuntimeException("Working with raw ContentResponse is invalid for WebSocket");
    }

    public void send(Response.CompleteListener listener) {
        this.initWebSocketHeaders();
        super.send(listener);
    }

    public CompletableFuture<Session> sendAsync() {
        this.send(this);
        return this.fut;
    }

    public void upgrade(HttpResponse response, HttpConnectionOverHTTP oldConn) {
        String[] extValues;
        String respHash;
        if (!this.getHeaders().get(HttpHeader.UPGRADE).equalsIgnoreCase("websocket")) {
            throw new HttpResponseException("Not WebSocket Upgrade", (Response)response);
        }
        String reqKey = this.getHeaders().get(HttpHeader.SEC_WEBSOCKET_KEY);
        String expectedHash = AcceptHash.hashKey((String)reqKey);
        if (!expectedHash.equalsIgnoreCase(respHash = response.getHeaders().get(HttpHeader.SEC_WEBSOCKET_ACCEPT))) {
            throw new HttpResponseException("Invalid Sec-WebSocket-Accept hash", (Response)response);
        }
        EndPoint endp = oldConn.getEndPoint();
        WebSocketClientConnection connection = new WebSocketClientConnection(endp, this.wsClient.getExecutor(), this.wsClient.getScheduler(), this.localEndpoint.getPolicy(), this.wsClient.getBufferPool());
        URI requestURI = this.getURI();
        WebSocketSession session = this.getSessionFactory().createSession(requestURI, this.localEndpoint, (LogicalConnection)connection);
        session.setUpgradeRequest((UpgradeRequest)new ClientUpgradeRequest(this));
        session.setUpgradeResponse((UpgradeResponse)new ClientUpgradeResponse(response));
        connection.addListener((Connection.Listener)session);
        ExtensionStack extensionStack = new ExtensionStack(this.getExtensionFactory());
        ArrayList<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        HttpField extField = response.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (extField != null && (extValues = extField.getValues()) != null) {
            for (String extVal : extValues) {
                QuotedStringTokenizer tok = new QuotedStringTokenizer(extVal, ",");
                while (tok.hasMoreTokens()) {
                    extensions.add(ExtensionConfig.parse((String)tok.nextToken()));
                }
            }
        }
        extensionStack.negotiate(extensions);
        extensionStack.configure(connection.getParser());
        extensionStack.configure(connection.getGenerator());
        connection.setNextIncomingFrames((IncomingFrames)extensionStack);
        extensionStack.setNextIncoming((IncomingFrames)session);
        session.setOutgoingHandler((OutgoingFrames)extensionStack);
        extensionStack.setNextOutgoing((OutgoingFrames)connection);
        session.addManaged((LifeCycle)extensionStack);
        session.setFuture(this.fut);
        this.wsClient.addManaged((LifeCycle)session);
        if (this.upgradeListener != null) {
            this.upgradeListener.onHandshakeResponse((UpgradeResponse)new ClientUpgradeResponse(response));
        }
        endp.upgrade((Connection)connection);
    }

    public void setUpgradeListener(UpgradeListener upgradeListener) {
        this.upgradeListener = upgradeListener;
    }

    private HttpFields getHttpFields() {
        return super.getHeaders();
    }

    private class ClientUpgradeRequestFacade
    implements UpgradeRequest {
        private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        private List<String> subProtocols = new ArrayList<String>();
        private Object session;

        public void init(ClientUpgradeRequest request) {
            this.extensions = new ArrayList<ExtensionConfig>(request.getExtensions());
            this.subProtocols = new ArrayList<String>(request.getSubProtocols());
            if (StringUtil.isNotBlank((String)request.getOrigin())) {
                WebSocketUpgradeRequest.this.header(HttpHeader.ORIGIN, request.getOrigin());
            }
            for (HttpCookie cookie : request.getCookies()) {
                WebSocketUpgradeRequest.this.cookie(cookie);
            }
        }

        public List<ExtensionConfig> getExtensions() {
            return this.extensions;
        }

        public List<String> getSubProtocols() {
            return this.subProtocols;
        }

        public void addExtensions(ExtensionConfig ... configs) {
            for (ExtensionConfig config : configs) {
                this.extensions.add(config);
            }
            this.updateExtensionHeader();
        }

        public void addExtensions(String ... configs) {
            this.extensions.addAll(ExtensionConfig.parseList((String[])configs));
            this.updateExtensionHeader();
        }

        public void clearHeaders() {
            throw new UnsupportedOperationException("Clearing all headers breaks WebSocket upgrade");
        }

        public String getHeader(String name) {
            return WebSocketUpgradeRequest.this.getHttpFields().get(name);
        }

        public int getHeaderInt(String name) {
            String value = WebSocketUpgradeRequest.this.getHttpFields().get(name);
            if (value == null) {
                return -1;
            }
            return Integer.parseInt(value);
        }

        public List<String> getHeaders(String name) {
            return WebSocketUpgradeRequest.this.getHttpFields().getValuesList(name);
        }

        public String getHttpVersion() {
            return WebSocketUpgradeRequest.this.getVersion().asString();
        }

        public String getOrigin() {
            return WebSocketUpgradeRequest.this.getHttpFields().get(HttpHeader.ORIGIN);
        }

        public Map<String, List<String>> getParameterMap() {
            TreeMap<String, List<String>> paramMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            String query = this.getQueryString();
            MultiMap multimap = new MultiMap();
            UrlEncoded.decodeTo((String)query, (MultiMap)multimap, (Charset)StandardCharsets.UTF_8);
            paramMap.putAll((Map<String, List<String>>)multimap);
            return paramMap;
        }

        public String getProtocolVersion() {
            String ver = WebSocketUpgradeRequest.this.getHttpFields().get(HttpHeader.SEC_WEBSOCKET_VERSION);
            if (ver == null) {
                return Integer.toString(13);
            }
            return ver;
        }

        public String getQueryString() {
            return WebSocketUpgradeRequest.this.getURI().getQuery();
        }

        public URI getRequestURI() {
            return WebSocketUpgradeRequest.this.getURI();
        }

        public Object getSession() {
            return this.session;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean hasSubProtocol(String test) {
            return this.getSubProtocols().contains(test);
        }

        public boolean isOrigin(String test) {
            return test.equalsIgnoreCase(this.getOrigin());
        }

        public boolean isSecure() {
            return "wss".equalsIgnoreCase(WebSocketUpgradeRequest.this.getURI().getScheme());
        }

        public void setCookies(List<HttpCookie> cookies) {
            for (HttpCookie cookie : cookies) {
                WebSocketUpgradeRequest.this.cookie(cookie);
            }
        }

        public void setExtensions(List<ExtensionConfig> configs) {
            this.extensions = configs;
            this.updateExtensionHeader();
        }

        private void updateExtensionHeader() {
            HttpFields headers = WebSocketUpgradeRequest.this.getHttpFields();
            headers.remove(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
            for (ExtensionConfig config : this.extensions) {
                headers.add(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, config.getParameterizedName());
            }
        }

        public void setHeader(String name, List<String> values) {
            WebSocketUpgradeRequest.this.getHttpFields().put(name, values);
        }

        public void setHeader(String name, String value) {
            WebSocketUpgradeRequest.this.getHttpFields().put(name, value);
        }

        public void setHeaders(Map<String, List<String>> headers) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                WebSocketUpgradeRequest.this.getHttpFields().put(entry.getKey(), entry.getValue());
            }
        }

        public void setHttpVersion(String httpVersion) {
            WebSocketUpgradeRequest.this.version(HttpVersion.fromString((String)httpVersion));
        }

        public void setMethod(String method) {
            WebSocketUpgradeRequest.this.method(method);
        }

        public void setRequestURI(URI uri) {
            throw new UnsupportedOperationException("Cannot reset/change RequestURI");
        }

        public void setSession(Object session) {
            this.session = session;
        }

        public void setSubProtocols(List<String> protocols) {
            this.subProtocols = protocols;
        }

        public void setSubProtocols(String ... protocols) {
            this.subProtocols.clear();
            this.subProtocols.addAll(Arrays.asList(protocols));
        }

        public List<HttpCookie> getCookies() {
            return WebSocketUpgradeRequest.this.getCookies();
        }

        public Map<String, List<String>> getHeaders() {
            TreeMap<String, List<String>> headersMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            HttpFields fields = WebSocketUpgradeRequest.this.getHttpFields();
            for (String name : fields.getFieldNamesCollection()) {
                headersMap.put(name, fields.getValuesList(name));
            }
            return headersMap;
        }

        public String getHost() {
            return WebSocketUpgradeRequest.this.getHost();
        }

        public String getMethod() {
            return WebSocketUpgradeRequest.this.getMethod();
        }
    }
}

