/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api.io;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.jetty.websocket.api.WebSocketConnection;
import org.eclipse.jetty.websocket.api.WebSocketException;

public class WebSocketBlockingConnection {
    private final WebSocketConnection conn;

    public WebSocketBlockingConnection(WebSocketConnection conn) {
        this.conn = conn;
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        try {
            Future<Void> blocker = this.conn.write(data, offset, length);
            blocker.get();
        }
        catch (InterruptedException e) {
            throw new WebSocketException("Blocking write failed", e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    public void write(String message) throws IOException {
        try {
            Future<Void> blocker = this.conn.write(message);
            blocker.get();
        }
        catch (InterruptedException e) {
            throw new WebSocketException("Blocking write failed", e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }
}

