/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.scopes.SimpleContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.jsr356.DecoderFactory;
import org.eclipse.jetty.websocket.jsr356.EncoderFactory;
import org.eclipse.jetty.websocket.jsr356.JsrExtension;
import org.eclipse.jetty.websocket.jsr356.JsrExtensionConfig;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.JsrSessionFactory;
import org.eclipse.jetty.websocket.jsr356.JsrUpgradeListener;
import org.eclipse.jetty.websocket.jsr356.annotations.AnnotatedEndpointScanner;
import org.eclipse.jetty.websocket.jsr356.client.AnnotatedClientEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.client.EmptyClientEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.client.SimpleEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.decoders.PrimitiveDecoderMetadataSet;
import org.eclipse.jetty.websocket.jsr356.encoders.PrimitiveEncoderMetadataSet;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.endpoints.JsrEventDriverFactory;
import org.eclipse.jetty.websocket.jsr356.metadata.EndpointMetadata;

public class ClientContainer
extends ContainerLifeCycle
implements WebSocketContainer,
WebSocketContainerScope {
    private static final Logger LOG = Log.getLogger(ClientContainer.class);
    private final WebSocketContainerScope scopeDelegate;
    private final DecoderFactory decoderFactory;
    private final EncoderFactory encoderFactory;
    private final WebSocketClient client;
    private final Map<Class<?>, EndpointMetadata> endpointClientMetadataCache;

    public ClientContainer() {
        this((WebSocketContainerScope)new SimpleContainerScope(WebSocketPolicy.newClientPolicy()));
        this.client.setDaemon(true);
    }

    public ClientContainer(WebSocketContainerScope scope) {
        boolean trustAll = Boolean.getBoolean("org.eclipse.jetty.websocket.jsr356.ssl-trust-all");
        this.scopeDelegate = scope;
        this.client = new WebSocketClient(scope, (EventDriverFactory)new JsrEventDriverFactory(scope), (SessionFactory)new JsrSessionFactory(this));
        this.client.getSslContextFactory().setTrustAll(trustAll);
        this.addBean(this.client);
        this.endpointClientMetadataCache = new ConcurrentHashMap();
        this.decoderFactory = new DecoderFactory(this, PrimitiveDecoderMetadataSet.INSTANCE);
        this.encoderFactory = new EncoderFactory(this, PrimitiveEncoderMetadataSet.INSTANCE);
        ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
    }

    private Session connect(EndpointInstance instance, URI path) throws IOException {
        Objects.requireNonNull(instance, "EndpointInstance cannot be null");
        Objects.requireNonNull(path, "Path cannot be null");
        ClientEndpointConfig config = (ClientEndpointConfig)instance.getConfig();
        ClientUpgradeRequest req = new ClientUpgradeRequest();
        JsrUpgradeListener upgradeListener = null;
        for (Extension ext : config.getExtensions()) {
            req.addExtensions(new ExtensionConfig[]{new JsrExtensionConfig(ext)});
        }
        if (config.getPreferredSubprotocols().size() > 0) {
            req.setSubProtocols(config.getPreferredSubprotocols());
        }
        if (config.getConfigurator() != null) {
            upgradeListener = new JsrUpgradeListener(config.getConfigurator());
        }
        Future futSess = this.client.connect((Object)instance, path, req, (UpgradeListener)upgradeListener);
        try {
            return (JsrSession)futSess.get();
        }
        catch (InterruptedException e) {
            throw new IOException("Connect failure", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Connect failure", cause);
        }
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig config, URI path) throws DeploymentException, IOException {
        EndpointInstance instance = this.newClientEndpointInstance(endpointClass, config);
        return this.connect(instance, path);
    }

    public Session connectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException, IOException {
        EndpointInstance instance = this.newClientEndpointInstance(annotatedEndpointClass, null);
        return this.connect(instance, path);
    }

    public Session connectToServer(Endpoint endpoint, ClientEndpointConfig config, URI path) throws DeploymentException, IOException {
        EndpointInstance instance = this.newClientEndpointInstance(endpoint, config);
        return this.connect(instance, path);
    }

    public Session connectToServer(Object endpoint, URI path) throws DeploymentException, IOException {
        EndpointInstance instance = this.newClientEndpointInstance(endpoint, null);
        return this.connect(instance, path);
    }

    protected void doStart() throws Exception {
        super.doStart();
        EmptyClientEndpointConfig empty = new EmptyClientEndpointConfig();
        this.decoderFactory.init((EndpointConfig)empty);
        this.encoderFactory.init((EndpointConfig)empty);
    }

    protected void doStop() throws Exception {
        ShutdownThread.deregister((LifeCycle)this);
        this.endpointClientMetadataCache.clear();
        super.doStop();
    }

    public ByteBufferPool getBufferPool() {
        return this.scopeDelegate.getBufferPool();
    }

    public WebSocketClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointMetadata getClientEndpointMetadata(Class<?> endpoint, EndpointConfig config) {
        Map<Class<?>, EndpointMetadata> map = this.endpointClientMetadataCache;
        synchronized (map) {
            EndpointMetadata metadata = this.endpointClientMetadataCache.get(endpoint);
            if (metadata != null) {
                return metadata;
            }
            ClientEndpoint anno = endpoint.getAnnotation(ClientEndpoint.class);
            if (anno != null) {
                AnnotatedClientEndpointMetadata annoMetadata = new AnnotatedClientEndpointMetadata(this, endpoint);
                AnnotatedEndpointScanner<ClientEndpoint, ClientEndpointConfig> scanner = new AnnotatedEndpointScanner<ClientEndpoint, ClientEndpointConfig>(annoMetadata);
                scanner.scan();
                metadata = annoMetadata;
            } else if (Endpoint.class.isAssignableFrom(endpoint)) {
                Class<?> eendpoint = endpoint;
                metadata = new SimpleEndpointMetadata(eendpoint, config);
            } else {
                StringBuilder err = new StringBuilder();
                err.append("Not a recognized websocket [");
                err.append(endpoint.getName());
                err.append("] does not extend @").append(ClientEndpoint.class.getName());
                err.append(" or extend from ").append(Endpoint.class.getName());
                throw new InvalidWebSocketException(err.toString());
            }
            this.endpointClientMetadataCache.put(endpoint, metadata);
            return metadata;
        }
    }

    public DecoderFactory getDecoderFactory() {
        return this.decoderFactory;
    }

    public long getDefaultAsyncSendTimeout() {
        return this.client.getAsyncWriteTimeout();
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.client.getMaxBinaryMessageBufferSize();
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.client.getMaxIdleTimeout();
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.client.getMaxTextMessageBufferSize();
    }

    public EncoderFactory getEncoderFactory() {
        return this.encoderFactory;
    }

    public Executor getExecutor() {
        return this.scopeDelegate.getExecutor();
    }

    public Set<Extension> getInstalledExtensions() {
        HashSet<Extension> ret = new HashSet<Extension>();
        ExtensionFactory extensions = this.client.getExtensionFactory();
        for (String name : extensions.getExtensionNames()) {
            ret.add(new JsrExtension(name));
        }
        return ret;
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this.scopeDelegate.getObjectFactory();
    }

    public Set<Session> getOpenSessions() {
        return new HashSet<Session>(this.getBeans(Session.class));
    }

    public WebSocketPolicy getPolicy() {
        return this.scopeDelegate.getPolicy();
    }

    public SslContextFactory getSslContextFactory() {
        return this.scopeDelegate.getSslContextFactory();
    }

    private EndpointInstance newClientEndpointInstance(Class<?> endpointClass, ClientEndpointConfig config) {
        try {
            return this.newClientEndpointInstance(endpointClass.newInstance(), config);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InvalidWebSocketException("Unable to instantiate websocket: " + endpointClass.getClass());
        }
    }

    public EndpointInstance newClientEndpointInstance(Object endpoint, ClientEndpointConfig config) {
        EndpointMetadata metadata = this.getClientEndpointMetadata(endpoint.getClass(), (EndpointConfig)config);
        Object cec = config;
        if (config == null) {
            cec = metadata instanceof AnnotatedClientEndpointMetadata ? ((AnnotatedClientEndpointMetadata)metadata).getConfig() : new EmptyClientEndpointConfig();
        }
        return new EndpointInstance(endpoint, (EndpointConfig)cec, metadata);
    }

    public void onSessionClosed(WebSocketSession session) {
        if (session instanceof Session) {
            this.removeBean(session);
        } else {
            LOG.warn("JSR356 Implementation should not be mixed with native implementation: Expected {} to implement {}", new Object[]{session.getClass().getName(), Session.class.getName()});
        }
    }

    public void onSessionOpened(WebSocketSession session) {
        if (session instanceof Session) {
            this.addManaged((LifeCycle)session);
        } else {
            LOG.warn("JSR356 Implementation should not be mixed with native implementation: Expected {} to implement {}", new Object[]{session.getClass().getName(), Session.class.getName()});
        }
    }

    public void setAsyncSendTimeout(long ms) {
        this.client.setAsyncWriteTimeout(ms);
    }

    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.client.getPolicy().setMaxBinaryMessageSize(max);
        this.client.setMaxBinaryMessageBufferSize(max);
    }

    public void setDefaultMaxSessionIdleTimeout(long ms) {
        this.client.setMaxIdleTimeout(ms);
    }

    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.client.getPolicy().setMaxTextMessageSize(max);
        this.client.setMaxTextMessageBufferSize(max);
    }
}

