/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.testing;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersions;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SimpleBuffers;
import org.eclipse.jetty.io.View;
import org.eclipse.jetty.io.bio.StringEndPoint;
import org.eclipse.jetty.util.ByteArrayOutputStream2;

public class HttpTester {
    protected HttpFields _fields = new HttpFields();
    protected String _method;
    protected String _uri;
    protected String _version;
    protected int _status;
    protected String _reason;
    protected ByteArrayOutputStream2 _parsedContent;
    protected byte[] _genContent;
    private String _charset;
    private String _defaultCharset;
    private Buffer _contentType;

    public HttpTester() {
        this("UTF-8");
    }

    public HttpTester(String charset) {
        this._defaultCharset = charset;
    }

    public void reset() {
        this._fields.clear();
        this._method = null;
        this._uri = null;
        this._version = null;
        this._status = 0;
        this._reason = null;
        this._parsedContent = null;
        this._genContent = null;
    }

    private String getString(Buffer buffer) {
        return this.getString(buffer.asArray());
    }

    private String getString(byte[] b) {
        if (this._charset == null) {
            return new String(b);
        }
        try {
            return new String(b, this._charset);
        }
        catch (Exception e) {
            return new String(b);
        }
    }

    private byte[] getByteArray(String str) {
        if (this._charset == null) {
            return str.getBytes();
        }
        try {
            return str.getBytes(this._charset);
        }
        catch (Exception e) {
            return str.getBytes();
        }
    }

    public String parse(String rawHTTP) throws IOException {
        this._charset = this._defaultCharset;
        ByteArrayBuffer buf = new ByteArrayBuffer(this.getByteArray(rawHTTP));
        View view = new View((Buffer)buf);
        HttpParser parser = new HttpParser((Buffer)view, (HttpParser.EventHandler)new PH());
        parser.parse();
        return this.getString(view.asArray());
    }

    public byte[] parse(byte[] rawHTTP) throws IOException {
        this._charset = this._defaultCharset;
        ByteArrayBuffer buf = new ByteArrayBuffer(rawHTTP);
        View view = new View((Buffer)buf);
        HttpParser parser = new HttpParser((Buffer)view, (HttpParser.EventHandler)new PH());
        parser.parse();
        return view.asArray();
    }

    public String generate() throws IOException {
        String charset;
        this._charset = this._defaultCharset;
        this._contentType = this._fields.get(HttpHeaders.CONTENT_TYPE_BUFFER);
        if (this._contentType != null && (charset = MimeTypes.getCharsetFromContentType((Buffer)this._contentType)) != null) {
            this._charset = charset;
        }
        ByteArrayBuffer bb = new ByteArrayBuffer(32768 + (this._genContent != null ? this._genContent.length : 0));
        ByteArrayBuffer sb = new ByteArrayBuffer(4096);
        StringEndPoint endp = new StringEndPoint(this._charset);
        HttpGenerator generator = new HttpGenerator((Buffers)new SimpleBuffers((Buffer)sb, (Buffer)bb), (EndPoint)endp);
        if (this._method != null) {
            generator.setRequest(this.getMethod(), this.getURI());
            if (this._version == null) {
                generator.setVersion(11);
            } else {
                generator.setVersion(HttpVersions.CACHE.getOrdinal(HttpVersions.CACHE.lookup(this._version)));
            }
            generator.completeHeader(this._fields, false);
            if (this._genContent != null) {
                generator.addContent((Buffer)new View((Buffer)new ByteArrayBuffer(this._genContent)), false);
            } else if (this._parsedContent != null) {
                generator.addContent((Buffer)new ByteArrayBuffer(this._parsedContent.toByteArray()), false);
            }
        }
        generator.complete();
        generator.flushBuffer();
        return endp.getOutput();
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public String getReason() {
        return this._reason;
    }

    public void setReason(String reason) {
        this._reason = reason;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public String getURI() {
        return this._uri;
    }

    public void setURI(String uri) {
        this._uri = uri;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String getContentType() {
        return this.getString(this._contentType);
    }

    public String getCharacterEncoding() {
        return this._charset;
    }

    public void addHeader(String name, String value) throws IllegalArgumentException {
        this._fields.add(name, value);
    }

    public void addDateHeader(String name, long date) {
        this._fields.addDateField(name, date);
    }

    public void addLongHeader(String name, long value) {
        this._fields.addLongField(name, value);
    }

    public void addSetCookie(Cookie cookie) {
        this._fields.addSetCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), (long)cookie.getMaxAge(), cookie.getComment(), cookie.getSecure(), cookie.isHttpOnly(), cookie.getVersion());
    }

    public long getDateHeader(String name) {
        return this._fields.getDateField(name);
    }

    public Enumeration getHeaderNames() {
        return this._fields.getFieldNames();
    }

    public long getLongHeader(String name) throws NumberFormatException {
        return this._fields.getLongField(name);
    }

    public String getHeader(String name) {
        return this._fields.getStringField(name);
    }

    public Enumeration getHeaderValues(String name) {
        return this._fields.getValues(name);
    }

    public void setHeader(String name, String value) {
        this._fields.put(name, value);
    }

    public void setDateHeader(String name, long date) {
        this._fields.putDateField(name, date);
    }

    public void setLongHeader(String name, long value) {
        this._fields.putLongField(name, value);
    }

    public void removeHeader(String name) {
        this._fields.remove(name);
    }

    public String getContent() {
        if (this._parsedContent != null) {
            return this.getString(this._parsedContent.toByteArray());
        }
        if (this._genContent != null) {
            return this.getString(this._genContent);
        }
        return null;
    }

    public byte[] getContentBytes() {
        if (this._parsedContent != null) {
            return this._parsedContent.toByteArray();
        }
        if (this._genContent != null) {
            return this._genContent;
        }
        return null;
    }

    public void setContent(String content) {
        this._parsedContent = null;
        if (content != null) {
            this._genContent = this.getByteArray(content);
            this.setLongHeader("Content-Length", this._genContent.length);
        } else {
            this.removeHeader("Content-Length");
            this._genContent = null;
        }
    }

    private class PH
    extends HttpParser.EventHandler {
        private PH() {
        }

        public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
            HttpTester.this.reset();
            HttpTester.this._method = HttpTester.this.getString(method);
            HttpTester.this._uri = HttpTester.this.getString(url);
            HttpTester.this._version = HttpTester.this.getString(version);
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
            HttpTester.this.reset();
            HttpTester.this._version = HttpTester.this.getString(version);
            HttpTester.this._status = status;
            HttpTester.this._reason = HttpTester.this.getString(reason);
        }

        public void parsedHeader(Buffer name, Buffer value) throws IOException {
            HttpTester.this._fields.add(name, value);
        }

        public void headerComplete() throws IOException {
            String charset;
            HttpTester.this._contentType = HttpTester.this._fields.get(HttpHeaders.CONTENT_TYPE_BUFFER);
            if (HttpTester.this._contentType != null && (charset = MimeTypes.getCharsetFromContentType((Buffer)HttpTester.this._contentType)) != null) {
                HttpTester.this._charset = charset;
            }
        }

        public void messageComplete(long contextLength) throws IOException {
        }

        public void content(Buffer ref) throws IOException {
            if (HttpTester.this._parsedContent == null) {
                HttpTester.this._parsedContent = new ByteArrayOutputStream2();
            }
            HttpTester.this._parsedContent.write(ref.asArray());
        }
    }
}

