/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;

public abstract class WebSocketHandler
extends HandlerWrapper {
    private WebSocketFactory _websocket;
    private int _bufferSize = 8192;

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    protected void doStart() throws Exception {
        this._websocket = new WebSocketFactory(this._bufferSize);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._websocket = null;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if ("WebSocket".equals(request.getHeader("Upgrade"))) {
            String protocol = request.getHeader("WebSocket-Protocol");
            WebSocket websocket = this.doWebSocketConnect(request, protocol);
            String host = request.getHeader("Host");
            String origin = request.getHeader("Origin");
            origin = this.checkOrigin(request, host, origin);
            if (websocket != null) {
                this._websocket.upgrade(request, response, websocket, origin, protocol);
            } else {
                response.sendError(503);
            }
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    protected String checkOrigin(HttpServletRequest request, String host, String origin) {
        if (origin == null) {
            origin = host;
        }
        return origin;
    }

    protected abstract WebSocket doWebSocketConnect(HttpServletRequest var1, String var2);
}

