/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.Callback;

public abstract class IteratingCallback
implements Callback {
    private final AtomicReference<State> _state = new AtomicReference<State>(State.WAITING);

    protected abstract boolean process() throws Exception;

    protected abstract void completed();

    public void iterate() {
        try {
            while (this._state.compareAndSet(State.WAITING, State.ITERATING)) {
                if (this.process()) {
                    if (!this._state.compareAndSet(State.ITERATING, State.SUCCEEDED)) {
                        throw new IllegalStateException("Already " + (Object)((Object)this._state.get()));
                    }
                    this.completed();
                    return;
                }
                if (!this._state.compareAndSet(State.ITERATING, State.WAITING)) continue;
                break;
            }
        }
        catch (Exception e) {
            this.failed(e);
        }
    }

    @Override
    public void succeeded() {
        if (this._state.compareAndSet(State.ITERATING, State.WAITING)) {
            return;
        }
        block4: while (true) {
            switch (this._state.get()) {
                case ITERATING: {
                    if (!this._state.compareAndSet(State.ITERATING, State.WAITING)) continue block4;
                    break block4;
                }
                case WAITING: {
                    this.iterate();
                    break block4;
                }
                default: {
                    throw new IllegalStateException("Already " + (Object)((Object)this._state.get()));
                }
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void failed(Throwable x) {
        block4: while (true) {
            switch (this._state.get()) {
                case ITERATING: {
                    if (!this._state.compareAndSet(State.ITERATING, State.FAILED)) continue block4;
                    return;
                }
                case WAITING: {
                    if (this._state.compareAndSet(State.WAITING, State.FAILED)) return;
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Already " + (Object)((Object)this._state.get()), x);
                }
            }
            break;
        }
    }

    private static enum State {
        WAITING,
        ITERATING,
        SUCCEEDED,
        FAILED;

    }
}

