/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebAppDecorator
implements ServletContextHandler.Decorator {
    private WebAppContext _wac;

    public WebAppDecorator(WebAppContext context) {
        this._wac = context;
    }

    public void decorateFilterHolder(FilterHolder filter) throws ServletException {
    }

    public <T extends Filter> T decorateFilterInstance(T filter) throws ServletException {
        this.decorate(filter);
        return filter;
    }

    public <T extends EventListener> T decorateListenerInstance(T listener) throws ServletException {
        this.decorate(listener);
        return listener;
    }

    public void decorateServletHolder(ServletHolder holder) throws ServletException {
        this.decorate(holder);
    }

    public <T extends Servlet> T decorateServletInstance(T servlet) throws ServletException {
        this.decorate(servlet);
        return servlet;
    }

    public void destroyFilterInstance(Filter f) {
        this.destroy(f);
    }

    public void destroyServletInstance(Servlet s) {
        this.destroy(s);
    }

    public void destroyListenerInstance(EventListener l) {
        this.destroy(l);
    }

    protected void decorate(Object o) throws ServletException {
        InjectionCollection injections = (InjectionCollection)this._wac.getAttribute("org.eclipse.jetty.injectionCollection");
        LifeCycleCallbackCollection callbacks = (LifeCycleCallbackCollection)this._wac.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
        RunAsCollection runAses = (RunAsCollection)this._wac.getAttribute("org.eclipse.jetty.runAsCollection");
        if (runAses != null) {
            runAses.setRunAs(o);
        }
        if (injections != null) {
            injections.inject(o);
        }
        if (callbacks != null) {
            try {
                callbacks.callPostConstructCallback(o);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void destroy(Object o) {
        LifeCycleCallbackCollection callbacks = (LifeCycleCallbackCollection)this._wac.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
        if (callbacks != null) {
            try {
                callbacks.callPreDestroyCallback(o);
            }
            catch (Exception e) {
                Log.warn((String)("Destroying instance of " + o.getClass()), (Throwable)e);
            }
        }
    }
}

