/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.convolutional.Cropping1D;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasCropping1D
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasCropping1D.class);

    public KerasCropping1D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasCropping1D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        String croppingField = this.conf.getLAYER_FIELD_CROPPING();
        int[] cropping = KerasConvolutionUtils.getPaddingFromConfig(layerConfig, this.conf, croppingField, 1);
        Cropping1D.Builder builder = (Cropping1D.Builder)((Cropping1D.Builder)new Cropping1D.Builder(cropping).name(this.layerName)).dropOut(this.dropout);
        this.layer = builder.build();
        this.vertex = null;
    }

    public Cropping1D getCropping1DLayer() {
        return (Cropping1D)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Cropping layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getCropping1DLayer().getOutputType(-1, inputType[0]);
    }

    public String toString() {
        return "KerasCropping1D()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasCropping1D)) {
            return false;
        }
        KerasCropping1D other = (KerasCropping1D)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasCropping1D;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

