/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.common.util.DL4JFileUtils;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.modelimport.keras.KerasModel;
import org.deeplearning4j.nn.modelimport.keras.KerasSequentialModel;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasModelImport {
    private static final Logger log = LoggerFactory.getLogger(KerasModelImport.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComputationGraph importKerasModelAndWeights(InputStream modelHdf5Stream, boolean enforceTrainingConfig) throws IOException, UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        File f = null;
        try {
            f = KerasModelImport.toTempFile(modelHdf5Stream);
            ComputationGraph computationGraph = KerasModelImport.importKerasModelAndWeights(f.getAbsolutePath(), enforceTrainingConfig);
            return computationGraph;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    public static ComputationGraph importKerasModelAndWeights(InputStream modelHdf5Stream) throws IOException, UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        File f = null;
        try {
            f = KerasModelImport.toTempFile(modelHdf5Stream);
            ComputationGraph computationGraph = KerasModelImport.importKerasModelAndWeights(f.getAbsolutePath());
            return computationGraph;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiLayerNetwork importKerasSequentialModelAndWeights(InputStream modelHdf5Stream, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        File f = null;
        try {
            f = KerasModelImport.toTempFile(modelHdf5Stream);
            MultiLayerNetwork multiLayerNetwork = KerasModelImport.importKerasSequentialModelAndWeights(f.getAbsolutePath(), enforceTrainingConfig);
            return multiLayerNetwork;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    public static MultiLayerNetwork importKerasSequentialModelAndWeights(InputStream modelHdf5Stream) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        File f = null;
        try {
            f = KerasModelImport.toTempFile(modelHdf5Stream);
            MultiLayerNetwork multiLayerNetwork = KerasModelImport.importKerasSequentialModelAndWeights(f.getAbsolutePath());
            return multiLayerNetwork;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    public static ComputationGraph importKerasModelAndWeights(String modelHdf5Filename, int[] inputShape, boolean enforceTrainingConfig) throws IOException, UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        KerasModel kerasModel = new KerasModel().modelBuilder.modelHdf5Filename(modelHdf5Filename).enforceTrainingConfig(enforceTrainingConfig).inputShape(inputShape).buildModel();
        return kerasModel.getComputationGraph();
    }

    public static ComputationGraph importKerasModelAndWeights(String modelHdf5Filename, boolean enforceTrainingConfig) throws IOException, UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        KerasModel kerasModel = new KerasModel().modelBuilder.modelHdf5Filename(modelHdf5Filename).enforceTrainingConfig(enforceTrainingConfig).buildModel();
        return kerasModel.getComputationGraph();
    }

    public static ComputationGraph importKerasModelAndWeights(String modelHdf5Filename) throws IOException, UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        KerasModel kerasModel = new KerasModel().modelBuilder().modelHdf5Filename(modelHdf5Filename).enforceTrainingConfig(true).buildModel();
        return kerasModel.getComputationGraph();
    }

    public static MultiLayerNetwork importKerasSequentialModelAndWeights(String modelHdf5Filename, int[] inputShape, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasSequentialModel().modelBuilder().modelHdf5Filename(modelHdf5Filename).enforceTrainingConfig(enforceTrainingConfig).inputShape(inputShape).buildSequential();
        return kerasModel.getMultiLayerNetwork();
    }

    public static MultiLayerNetwork importKerasSequentialModelAndWeights(String modelHdf5Filename, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasSequentialModel().modelBuilder().modelHdf5Filename(modelHdf5Filename).enforceTrainingConfig(enforceTrainingConfig).buildSequential();
        return kerasModel.getMultiLayerNetwork();
    }

    public static MultiLayerNetwork importKerasSequentialModelAndWeights(String modelHdf5Filename) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasSequentialModel().modelBuilder().modelHdf5Filename(modelHdf5Filename).enforceTrainingConfig(true).buildSequential();
        return kerasModel.getMultiLayerNetwork();
    }

    public static ComputationGraph importKerasModelAndWeights(String modelJsonFilename, String weightsHdf5Filename, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasModel kerasModel = new KerasModel().modelBuilder().modelJsonFilename(modelJsonFilename).enforceTrainingConfig(false).weightsHdf5FilenameNoRoot(weightsHdf5Filename).enforceTrainingConfig(enforceTrainingConfig).buildModel();
        return kerasModel.getComputationGraph();
    }

    public static ComputationGraph importKerasModelAndWeights(String modelJsonFilename, String weightsHdf5Filename) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasModel kerasModel = new KerasModel().modelBuilder().modelJsonFilename(modelJsonFilename).enforceTrainingConfig(false).weightsHdf5FilenameNoRoot(weightsHdf5Filename).enforceTrainingConfig(true).buildModel();
        return kerasModel.getComputationGraph();
    }

    public static MultiLayerNetwork importKerasSequentialModelAndWeights(String modelJsonFilename, String weightsHdf5Filename, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasSequentialModel().modelBuilder().modelJsonFilename(modelJsonFilename).weightsHdf5FilenameNoRoot(weightsHdf5Filename).enforceTrainingConfig(enforceTrainingConfig).buildSequential();
        return kerasModel.getMultiLayerNetwork();
    }

    public static MultiLayerNetwork importKerasSequentialModelAndWeights(String modelJsonFilename, String weightsHdf5Filename) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasSequentialModel().modelBuilder().modelJsonFilename(modelJsonFilename).weightsHdf5FilenameNoRoot(weightsHdf5Filename).enforceTrainingConfig(false).buildSequential();
        return kerasModel.getMultiLayerNetwork();
    }

    public static ComputationGraphConfiguration importKerasModelConfiguration(String modelJsonFilename, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasModel kerasModel = new KerasModel().modelBuilder().modelJsonFilename(modelJsonFilename).enforceTrainingConfig(enforceTrainingConfig).buildModel();
        return kerasModel.getComputationGraphConfiguration();
    }

    public static ComputationGraphConfiguration importKerasModelConfiguration(String modelJsonFilename) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasModel kerasModel = new KerasModel().modelBuilder().modelJsonFilename(modelJsonFilename).enforceTrainingConfig(false).buildModel();
        return kerasModel.getComputationGraphConfiguration();
    }

    public static MultiLayerConfiguration importKerasSequentialConfiguration(String modelJsonFilename, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasSequentialModel().modelBuilder().modelJsonFilename(modelJsonFilename).enforceTrainingConfig(enforceTrainingConfig).buildSequential();
        return kerasModel.getMultiLayerConfiguration();
    }

    public static MultiLayerConfiguration importKerasSequentialConfiguration(String modelJsonFilename) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasSequentialModel().modelBuilder().modelJsonFilename(modelJsonFilename).enforceTrainingConfig(false).buildSequential();
        return kerasModel.getMultiLayerConfiguration();
    }

    private static File toTempFile(InputStream is) throws IOException {
        File f = DL4JFileUtils.createTempFile((String)"DL4JKerasModelImport", (String)".bin");
        f.deleteOnExit();
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));){
            IOUtils.copy((InputStream)is, (OutputStream)os);
            ((OutputStream)os).flush();
            File file = f;
            return file;
        }
    }
}

