/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.quality.real;

import java.io.Serializable;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.quality.columns.DoubleQuality;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.common.function.BiFunction;

public class RealQualityAddFunction
implements BiFunction<DoubleQuality, Writable, DoubleQuality>,
Serializable {
    private final DoubleMetaData meta;

    public DoubleQuality apply(DoubleQuality v1, Writable writable) {
        long valid = v1.getCountValid();
        long invalid = v1.getCountInvalid();
        long countMissing = v1.getCountMissing();
        long countTotal = v1.getCountTotal() + 1L;
        long nonReal = v1.getCountNonReal();
        long nan = v1.getCountNaN();
        long infinite = v1.getCountInfinite();
        if (this.meta.isValid(writable)) {
            ++valid;
        } else if (writable instanceof NullWritable || writable instanceof Text && (writable.toString() == null || writable.toString().isEmpty())) {
            ++countMissing;
        } else {
            ++invalid;
        }
        String str = writable.toString();
        try {
            double d = Double.parseDouble(str);
            if (Double.isNaN(d)) {
                ++nan;
            }
            if (Double.isInfinite(d)) {
                ++infinite;
            }
        }
        catch (NumberFormatException e) {
            ++nonReal;
        }
        return new DoubleQuality(valid, invalid, countMissing, countTotal, nonReal, nan, infinite);
    }

    public RealQualityAddFunction(DoubleMetaData meta) {
        this.meta = meta;
    }
}

