/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.counter;

import org.datavec.api.transform.analysis.AnalysisCounter;
import org.datavec.api.transform.analysis.counter.StatCounter;
import org.datavec.api.writable.Writable;

public class StringAnalysisCounter
implements AnalysisCounter<StringAnalysisCounter> {
    private StatCounter counter = new StatCounter();
    private long countZeroLength = 0L;
    private long countMinLength = 0L;
    private long countMaxLength = 0L;

    public StringAnalysisCounter() {
    }

    public int getMinLengthSeen() {
        return (int)this.counter.getMin();
    }

    public int getMaxLengthSeen() {
        return (int)this.counter.getMax();
    }

    public long getSumLength() {
        return (long)this.counter.getSum();
    }

    public long getCountTotal() {
        return this.counter.getCount();
    }

    public double getSampleStdev() {
        return this.counter.getStddev(false);
    }

    public double getMean() {
        return this.counter.getMean();
    }

    public double getSampleVariance() {
        return this.counter.getVariance(false);
    }

    @Override
    public StringAnalysisCounter add(Writable writable) {
        int length = writable.toString().length();
        if (length == 0) {
            ++this.countZeroLength;
        }
        if (length == this.getMinLengthSeen()) {
            ++this.countMinLength;
        } else if (length < this.getMinLengthSeen()) {
            this.countMinLength = 1L;
        }
        if (length == this.getMaxLengthSeen()) {
            ++this.countMaxLength;
        } else if (length > this.getMaxLengthSeen()) {
            this.countMaxLength = 1L;
        }
        this.counter.add(length);
        return this;
    }

    @Override
    public StringAnalysisCounter merge(StringAnalysisCounter other) {
        int otherMin = other.getMinLengthSeen();
        long newCountMinLength = this.getMinLengthSeen() == otherMin ? this.countMinLength + other.getCountMinLength() : (this.getMinLengthSeen() > otherMin ? other.getCountMinLength() : this.countMinLength);
        int otherMax = other.getMaxLengthSeen();
        long newCountMaxLength = this.getMaxLengthSeen() == otherMax ? this.countMaxLength + other.getCountMaxLength() : (this.getMaxLengthSeen() < otherMax ? other.getCountMaxLength() : this.countMaxLength);
        return new StringAnalysisCounter(this.counter.merge(other.getCounter()), this.countZeroLength + other.getCountZeroLength(), newCountMinLength, newCountMaxLength);
    }

    public StringAnalysisCounter(StatCounter counter, long countZeroLength, long countMinLength, long countMaxLength) {
        this.counter = counter;
        this.countZeroLength = countZeroLength;
        this.countMinLength = countMinLength;
        this.countMaxLength = countMaxLength;
    }

    public StatCounter getCounter() {
        return this.counter;
    }

    public long getCountZeroLength() {
        return this.countZeroLength;
    }

    public long getCountMinLength() {
        return this.countMinLength;
    }

    public long getCountMaxLength() {
        return this.countMaxLength;
    }

    public void setCounter(StatCounter counter) {
        this.counter = counter;
    }

    public void setCountZeroLength(long countZeroLength) {
        this.countZeroLength = countZeroLength;
    }

    public void setCountMinLength(long countMinLength) {
        this.countMinLength = countMinLength;
    }

    public void setCountMaxLength(long countMaxLength) {
        this.countMaxLength = countMaxLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringAnalysisCounter)) {
            return false;
        }
        StringAnalysisCounter other = (StringAnalysisCounter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatCounter this$counter = this.getCounter();
        StatCounter other$counter = other.getCounter();
        if (this$counter == null ? other$counter != null : !this$counter.equals(other$counter)) {
            return false;
        }
        if (this.getCountZeroLength() != other.getCountZeroLength()) {
            return false;
        }
        if (this.getCountMinLength() != other.getCountMinLength()) {
            return false;
        }
        return this.getCountMaxLength() == other.getCountMaxLength();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringAnalysisCounter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatCounter $counter = this.getCounter();
        result = result * 59 + ($counter == null ? 43 : $counter.hashCode());
        long $countZeroLength = this.getCountZeroLength();
        result = result * 59 + (int)($countZeroLength >>> 32 ^ $countZeroLength);
        long $countMinLength = this.getCountMinLength();
        result = result * 59 + (int)($countMinLength >>> 32 ^ $countMinLength);
        long $countMaxLength = this.getCountMaxLength();
        result = result * 59 + (int)($countMaxLength >>> 32 ^ $countMaxLength);
        return result;
    }

    public String toString() {
        return "StringAnalysisCounter(counter=" + this.getCounter() + ", countZeroLength=" + this.getCountZeroLength() + ", countMinLength=" + this.getCountMinLength() + ", countMaxLength=" + this.getCountMaxLength() + ")";
    }
}

