package org.codehaus.xfire.plexus;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.ServiceLocator;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ObjectInvoker;

/**
 * Invokes a Plexus service.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Nov 18, 2004
 */
public class ServiceInvoker
	extends ObjectInvoker
{
    private static Log logger = LogFactory.getLog(ServiceInvoker.class.getName());
    
    private ServiceLocator locator;
    private String role;
    
    public ServiceInvoker( String role, ServiceLocator locator )
    {
        this.role = role;
        this.locator = locator;
    }

    public Object createServiceObject(Service service)
        throws XFireFault
    {
        try
        {
            return locator.lookup(role);
        }
        catch (ComponentLookupException e)
        {
            throw new XFireFault("Couldn't find service object.", e, XFireFault.RECEIVER);
        }
    }

}
